%% 清空环境变量
clear;clc;
close all;
%% 一、初始参数设定模块
%现场尺寸-x和y最大值（单位：米）
xm = 800;
ym = 800;

%基站的坐标
sink.x = 0.5 * xm;
sink.y = 0.5 * ym;

%场地中的节点数
n = 100;

%簇头概率
chp=0.05;

packetLength = 2000;%数据包长度 
ctrPacketLength = 100;%控制包长度

%能量模型（所有值均以焦耳为单位）
Eo = 4;%初始能量
ETX = 50*0.000000001;%耗传输能耗
ERX = 50*0.000000001;%接收能耗
EDA = 5*0.000000001;%数据聚合能量

%发射放大器类型
 Efs = 10*0.000000000001;%小于do
 Emp = 0.0013*0.000000000001;%大于do
 
do = sqrt(Efs/Emp);

%整个数据传输最大轮数…………………………
rmax = 1000;


%% 2、无线传感器网络模型产生模块
figure;
%构建无线传感器网络,在区域内均匀投放100个节点,并画出图形
for i = 1:n
    S(i).xd = rand(1,1)*xm;%坐标rand()函数随机生成
    S(i).yd = rand(1,1)*ym;
    S(i).G = 0;  % 
    S(i).type = 'N';%普通节点 
    S(i).E = Eo;
    plot(S(i).xd,S(i).yd,'o');
    hold on;
    CG(i).xd = S(i).xd;   %  坐标X轴rand()函数随机生成
    CG(i).yd = S(i).xd;   %  坐标Y轴rand()函数随机生成
    CG(i).G = 0;  % 成为簇头的次数
    CG(i).type = 'N';   %  普通节点 
    CG(i).E = Eo;  %  节点能量
    O(i).xd = S(i).xd;   %  坐标X轴rand()函数随机生成
    O(i).yd = S(i).xd;   %  坐标Y轴rand()函数随机生成
    O(i).G = 0;  % 成为簇头的次数
    O(i).type = 'N';   %  普通节点 
    O(i).E = Eo;  %  节点能量
    SO(i).xd = S(i).xd;%坐标
    SO(i).yd = S(i).yd;
    SO(i).E = Eo;%初始化节点能量
    %最初没有簇头只有簇成员
    SO(i).type = 'N';%簇成员(普通节点) 
end

S(n+1).xd = sink.x;
S(n+1).yd = sink.y;
plot(S(n+1).xd,S(n+1).yd,'*');
CG(n+1).xd = sink.x;  % 基站坐标
CG(n+1).yd = sink.y;  
O(n+1).xd = sink.x;  % 基站坐标
O(n+1).yd = sink.y;
SO(n+1).xd = sink.x;
SO(n+1).yd = sink.y;
%% 三、网络运行模块(CM-OOA)
% 死亡节点数
dead3 = 0; % 死亡节点数目
first_dead3 = 0;%第一个死亡节点
teenth_dead3 = 0;%10%的死亡节点
all_dead3 = 0;%节点都死亡
%标记
flag_first_dead3 = 0;
flag_teenth_dead3 = 0;
flag_all_dead3 = 0;
% 传输到基站和簇头的比特计数器
packets_TO_BS3 = 0;
packets_TO_CH3 = 0;
for r = 0:rmax % 主循环
    energy3 = 0;% 每轮节点剩余总能量
    cun = 1;
    cunhuo = [];
    X = [];% 初始化一个新的X矩阵，用于存储存活节点的坐标
    for Ei = 1:n   % 所有节点进行判断
        if O(Ei).E>0  % 判断存活节点是否为0
            cunhuo(cun) = Ei;
            cun = cun + 1;
            numcunhuo = length(cunhuo);
            % 如果存活，提取节点的坐标并添加到X矩阵中
            X = [X; O(Ei).xd O(Ei).yd];
        end
    end
    dead3 = n - numcunhuo;
    % (3)第一个死亡节点的产生时间(用轮次表示)
    % 第一个节点死亡时间
    if dead3 == 1
       if flag_first_dead3 == 0
          first_dead3 = r;
          flag_first_dead3 = 1;
       end
    end
    % 10%的节点死亡时间
    if dead3 == 0.1*n
       if flag_teenth_dead3 ==0
          teenth_dead3 = r;
          flag_teenth_dead3 = 1;
       end
    end
    if dead3 == n
       if flag_all_dead3 == 0
          all_dead3 = r;
          flag_all_dead3 = 1;
       end
    end
    for sw = 1:numcunhuo
        if O(cunhuo(sw)).E > 0
           energy3 = energy3 + O(cunhuo(sw)).E;%统计每轮节点总能量和
        end
    end
    STATISTICS3.DEAD(r+1) = dead3;
    STATISTICS3.alive(r+1) = numcunhuo;
    STATISTICS3.energy(r+1) = energy3;
    cluster = 0;%计数簇头数
%%  1、为优化算法生成种群
    if length(cunhuo) >25
       originalArray = cunhuo;  %  n个节点按顺序组成的数组
       k = ceil(numcunhuo*0.04);  % 最优簇头数(根据LEACH协议论文中） 向上取整
       num_zhongqun = 30;  % 种群个体数量规模(偶数）
       PopPos = [];   % 种群allSelections矩阵
%%   Kmeans++
%     % 绘制数据集
%     figure;
%     plot(X(:, 1), X(:, 2), 'k.');
%     title('Data Set');
%     xlabel('x1');
%     ylabel('x2');
    
    % 聚类
    [idx, C1] = mykmeans(X, k);
 
    % 初始化四个簇的空数组
    Cluster_1 = [];
    Cluster_2 = [];
    Cluster_3 = [];
    Cluster_4 = [];

    % 根据聚类标签idx将点分配到相应的簇数组中
    for i = 1:numcunhuo
        switch idx(i)
            case 1
                Cluster_1 = [Cluster_1; X(i, :)];
            case 2
                Cluster_2 = [Cluster_2; X(i, :)];
            case 3
                Cluster_3 = [Cluster_3; X(i, :)];
            case 4
                Cluster_4 = [Cluster_4; X(i, :)];
    	end
    end
%     % 绘制聚类结果
%     figure;
%     gscatter(X(:, 1), X(:, 2), idx);
%     hold on;
%     plot(C1(:, 1), C1(:, 2), 'kx', 'MarkerSize', 10, 'LineWidth', 3);
%     hold off;
%     title('Clustering Result');
%     xlabel('x1');
%     ylabel('x2');
%     legend('Cluster 1', 'Cluster 2', 'Cluster 3', 'Cluster 4', 'Centers');
    fdj3 = []; % 定义空向量放置节点到所有预选簇头的距离
    CHdj = []; % 假设初始时CH为0
    for zx = 1:length(C1)
        for xj = 1:numcunhuo
            q4 = 0.4;  %  节点到预选簇头的权值
            q5 = 0.6;  %  预选簇头能量的权值
            Ejd = 1/O(cunhuo(xj)).E;
            dzj = sqrt((O(cunhuo(xj)).xd - C1(zx, 1))^2 + (O(cunhuo(xj)).yd - C1(zx, 2))^2);
            xch = q4*dzj + q5*Ejd; % 选取簇头时的适应度函数
            fdj3(xj) = xch;  % 适应度函数值放入空向量中
            minD = min(fdj3); % 找最小适应度函数
            CHwz = find(fdj3 == minD); % 最小距离的节点在fjd3中的位置
            CHj = cunhuo(CHwz);  % 在fd3中提取出距离最小位置的节点CH即簇头
        end
        CHdj(zx) = CHj;
    end
    PopPos = [PopPos;CHdj];
    k = length(PopPos);
       for gm = 1:(num_zhongqun-1)   % 从N个节点中随机选取其中K个共进行30次，生成种群规模
           randomIndex = randi(length(cunhuo));
           jiedian = cunhuo(randomIndex);  % 随机选取出第一个节点
           zhongq1 = 0.6;
           zhongq2 = 0.4;
           selectedNumbers = [];
           for hd = 1:k
               selectedNumbers(hd) = jiedian;
               x = O(jiedian).xd;
               y = O(jiedian).yd;
               zr = 20;
               a = 3;
               [Nx,Ny] = chaotic_map(x,y,zr,a);  %  个体位置混沌映射
               zhong = [];
               zhong1 = 1;
               for zhongq = 1:numcunhuo % 种群虚假位置映射
                   flinjvd = sqrt((Nx - O(cunhuo(zhongq)).xd)^2 + (Ny - O(cunhuo(zhongq)).yd)^2);  % 虚假位置节点到其他存活节点的距离
                   zhenshihanshu = flinjvd * zhongq1 + (1/(O(cunhuo(zhongq)).E+1)) * zhongq2; % 虚假位置的函数值
                   zhong(zhong1) = zhenshihanshu;  % 虚假节点的函数值
                   zhong1 = zhong1 + 1;
               end
               minV3 = min(zhong);  % 函数值最小值
               minI3 = find(zhong == minV3);  % 函数值最小值位置
               if length(minI3) >1
                  minI3 = minI3(1);
               end
               jiedian = cunhuo(minI3);   %  虚假位置映射到真实位置
           end
           PopPos = [PopPos;selectedNumbers];  % 将selectedNumbers数组放入种群PopPos矩阵中
       end
%%  2、通过优化算法在种群中找到最优的结果
    PopFit = fitooa(PopPos,O,num_zhongqun,k,numcunhuo,cunhuo);  % 初始化种群的调用适应度函数计算适应度
    BestF=inf;  % 将BestF（最优适应度值）初始化为无穷大（inf）
    BestX=[];  % 将BestX（最优解的位置）初始化为空数组。
    % for i=1:nPop：这是一个 for 循环，它从 1 遍历到 nPop，其中 nPop 是种群的大小，即种群中个体的数量。
    % if PopFit(i) <= BestF：这是一个 if 条件语句，它检查当前个体的适应度值 PopFit(i) 是否小于或等于当前记录的最优适应度 BestF。
    % BestF=PopFit(i);：如果当前个体的适应度值更好（即更小，因为我们通常希望最小化适应度函数），则更新 BestF 为这个新的适应度值。
    % BestX=PopPos(i,:);：同时，将当前个体的位置 PopPos(i,:) 赋值给 BestX，这样 BestX 就保存了当前最优解的位置。
    for q = 1:num_zhongqun   % 将初始化种群的结果最好的保留在BestF和BestX中
        if PopFit(q)<=BestF 
           BestF=PopFit(q);
           BestX=PopPos(q,:);
        end
    end
%% 形成鱼鹰个体的鱼群并移动
    diedai = 30; % 迭代次数
    for t = 1:diedai  % 种群迭代
        for f1 = 1:num_zhongqun  % 获取鱼鹰个体的适应度值
            fi = 1;
            fishq = [];  % 空鱼群
            for f2 = 1:num_zhongqun  %  获取其他鱼鹰个体的适应度值
                if PopFit(f1)>PopFit(f2) % 鱼鹰个体的适应度值与其他鱼鹰适应度值比较形成鱼群
                   fish = PopPos(f2,:);
                   fishq = [fishq;fish];  % 形成鱼群
                   fi = fi + 1;
                end
            end
            num_fish = size(fishq,1); % 获取鱼群矩阵的行数即鱼群中鱼的条数
            yuying = PopPos(f1,:);  % 获取鱼鹰开始位置数组
            yuyingPopFit = PopFit(f1); % 获取鱼鹰捕鱼之前的适应度值
            if num_fish > 0 % 判断鱼群是否有鱼
               zhua = randi([1,num_fish]); % 鱼鹰个体开始随机寻找目标鱼
               mubiaofish = fishq(zhua,:); % 随机目标鱼位置数组
               for buyu = 1:k % 鱼鹰个体开始捕鱼
                   fby = mubiaofish(buyu); % 获取随机目标鱼维度位置
                   yby = yuying(buyu); % 获取鱼鹰维度位置 
                   rij = rand;
                   s = rand;
                   if s > 0.5
                       Iij = 1;
                   else 
                       Iij = 2;
                   end
                   yuyingxujiaxd = O(yby).xd + rij * (O(fby).xd - Iij * O(yby).xd); % 鱼鹰捕鱼后的虚假X位置
                   yuyingxujiayd = O(yby).yd + rij * (O(fby).yd - Iij * O(yby).yd); % 鱼鹰捕鱼后的虚假Y位置
                   buyuq1 = 0.6;
                   buyuq2 = 0.4;
                   flj1 = 1;
                   flj = []; % 存放鱼的虚假节点
                   for flinjv = 1:numcunhuo % 捕鱼位置映射
                       flinjvd = sqrt((yuyingxujiaxd - O(cunhuo(flinjv)).xd)^2 + (yuyingxujiayd - O(cunhuo(flinjv)).yd)^2);  % 鱼虚假位置节点到其他存活节点的距离
                       zhenshihanshu = flinjvd * buyuq1 + (1/(O(cunhuo(flinjv)).E+1)) * buyuq2; % 虚假位置的函数值
                       flj(flj1) = zhenshihanshu;  % 鱼鹰虚假节点的函数值
                       flj1 = flj1 + 1;
                   end
                   minV = min(flj);  % 函数值最小值
                   minI = find(flj == minV);  % 函数值最小值位置
                   if length(minI) >1
                       minI = minI(1);
                   end
                   buyuhou = cunhuo(minI);   %  鱼鹰捕鱼后真实位置
                   while true
                         if buyuhou ~= yuying  % 捕鱼后节点位置与鱼鹰其他位置是否一样
                            yuying(buyu) = buyuhou; 
                            PopPos(f1,buyu) = buyuhou;
                            break;
                         else
                            tb =  randi([1,numcunhuo]);
                            buyuhou = cunhuo(tb);  % 如果一样则从存活节点中随机找一个
                         end
                   end
               end  % 鱼鹰个体的所有位置更新
               byhPopFit = fitooa(yuying,O,1,k,numcunhuo,cunhuo); % 鱼鹰捕鱼后位置的适应度值
               PopFit(f1) = byhPopFit; % 捕鱼后新的适应度值替换捕鱼前的
               if byhPopFit < BestF % 捕鱼后的适应度值与最好的进行比较，保留最小的适应度值及位值数组
                  BestF = byhPopFit;
                  BestX = yuying;
               end
               if yuyingPopFit >  byhPopFit % 捕鱼后适应度值变好则捕到鱼，进行吃鱼操作。否则则视为未捕到鱼则不进行吃鱼操作
                  for chiyu = 1:k  % 鱼鹰个体开始吃鱼
                      ycy = yuying(chiyu); % 获取鱼鹰维度位置
                      lbj = 0;
                      Ubj = xm;
                      rij = rand;
                      ycyxujiaxd = O(ycy).xd + ((lbj + rij * (Ubj-lbj))/t);   % 鱼鹰吃鱼后虚假X位置
                      ycyxujiayd = O(ycy).yd + ((lbj + rij * (Ubj-lbj))/t);   % 鱼鹰吃鱼后虚假Y位置
                      chiyuq1 = 0.6;
                      chiyuq2 = 0.4;
                      flj2 = 1;
                      clj = []; % 存放鱼的邻居节点
                      for flinjv2 = 1:numcunhuo % 鱼鹰吃鱼位置映射
                          flinjvd2 = sqrt((ycyxujiaxd - O(cunhuo(flinjv2)).xd)^2 + (ycyxujiayd - O(cunhuo(flinjv2)).yd)^2);  % 鱼位置节点到其他存活节点的距离
                          zhenshihanshu2 = flinjvd2 * chiyuq1 + (1/(O(cunhuo(flinjv2)).E+1)) * chiyuq2;
                          clj(flj2) = zhenshihanshu2;  % 鱼位置节点一定范围的其他节点
                          flj2 = flj2 + 1;
                      end
                      minV2 = min(clj);  % 函数值最小值
                      minI2 = find(clj == minV2);  % 函数值最小值位置
                      if length(minI2) >1
                          minI2 = minI2(1);
                      end
                      chiyuhou = cunhuo(minI2);   %  鱼鹰吃鱼后位置
                      while true
                            if chiyuhou ~= yuying  % 吃鱼后节点位置与鱼鹰其他位置是否一样
                               yuying(chiyu) = chiyuhou; 
                               PopPos(f1,chiyu) = chiyuhou;
                               break;
                            else
                               tb1 =  randi([1,numcunhuo]);
                               chiyuhou = cunhuo(tb1);  % 如果一样则从存活节点中随机找一个
                            end 
                      end
                  end  % 鱼鹰个体所有位置更新
                  cyhPopFit = fitooa(yuying,O,1,k,numcunhuo,cunhuo); % 鱼鹰捕鱼后位置的适应度值
                  PopFit(f1) = cyhPopFit; % 捕鱼后新的适应度值替换捕鱼前的
                  if cyhPopFit < BestF % 捕鱼后的适应度值与最好的进行比较，保留最小的适应度值及位值数组
                     BestF = cyhPopFit;
                     BestX = yuying;
                  end
              end  % 鱼鹰是否吃鱼
          else % 鱼群没有鱼，即视为已经捕到鱼直接吃鱼
              for chiyu = 1:k  % 鱼鹰个体开始吃鱼
                  ycy = yuying(chiyu); % 获取鱼鹰维度位置
                  lbj = 0;
                  Ubj = xm;
                  rij = rand;
                  ycyxujiaxd = O(ycy).xd + ((lbj + rij * (Ubj-lbj))/t);   % 鱼鹰吃鱼后虚假X位置
                  ycyxujiayd = O(ycy).yd + ((lbj + rij * (Ubj-lbj))/t);   % 鱼鹰吃鱼后虚假Y位置
                  chiyuq1 = 0.6;
                  chiyuq2 = 0.4;
                  flj2 = 1;
                  clj = []; % 存放鱼的邻居节点
                  for flinjv2 = 1:numcunhuo % 鱼鹰吃鱼位置映射
                      flinjvd2 = sqrt((ycyxujiaxd - O(cunhuo(flinjv2)).xd)^2 + (ycyxujiayd - O(cunhuo(flinjv2)).yd)^2);  % 鱼位置节点到其他存活节点的距离
                      zhenshihanshu2 = flinjvd2 * chiyuq1 + (1/(O(cunhuo(flinjv2)).E+1)) * chiyuq2;
                      clj(flj2) = zhenshihanshu2;  % 鱼位置节点一定范围的其他节点
                      flj2 = flj2 + 1;
                  end
                  minV2 = min(clj);  % 函数值最小值
                  minI2 = find(clj == minV2);  % 函数值最小值位置
                  if length(minI2) >1
                     minI2 = minI2(1);
                  end
                  chiyuhou = cunhuo(minI2);   %  鱼鹰吃鱼后位置
                  while true
                       if chiyuhou ~= yuying  % 吃鱼后节点位置与鱼鹰其他位置是否一样
                          yuying(chiyu) = chiyuhou; 
                          PopPos(f1,chiyu) = chiyuhou;
                          break;
                       else
                          tb2 =  randi([1,numcunhuo]);
                          chiyuhou = cunhuo(tb2);  % 如果一样则从存活节点中随机找一个
                       end 
                  end
             end  % 鱼鹰个体所有位置更新
             cyhPopFit = fitooa(yuying,O,1,k,numcunhuo,cunhuo); % 鱼鹰捕鱼后位置的适应度值
             PopFit(f1) = cyhPopFit; % 捕鱼后新的适应度值替换捕鱼前的
             if cyhPopFit < BestF % 捕鱼后的适应度值与最好的进行比较，保留最小的适应度值及位值数组
                BestF = cyhPopFit;
                BestX = yuying;
             end
           end % 鱼群是否有鱼
        end  % 鱼鹰个体适应度值
        if r > (rmax/2) %  $$$$$$$$
           BestX = CHdj; %￥￥￥￥￥￥
        end      %  $$$$$$$
   end  % 种群迭代
   BGT=BestX;  % 获取最优个体即簇头
   chnum =  length(BGT);  % 簇头数量
   for sdd = 1:chnum  % 簇头次数加一
       O(sdd).G = O(sdd).G+1; 
   end
    %基站广播簇头，所有节点接收
   for gb = 1:numcunhuo
       O(cunhuo(gb)).E = O(cunhuo(gb)).E - ERX * ctrPacketLength;
   end
%%  4、普通节点入簇
   pt = 1;
   putong = [];  % 直接传输给基站的普通节点需要一直存储所以不能再循环中不然会变为空向量
   for i =1:numcunhuo % 存活节点选择簇头
        if O(cunhuo(i)).E>0 % 判断节点是否有能量
        if cunhuo(i) ~= BGT  % 簇头节点不进行入簇
           YCH = []; % 每次更新为空向量，来放置预选簇头
           d1= sqrt((O(cunhuo(i)).xd - sink.x)^2 + (O(cunhuo(i)).yd - sink.y)^2);  % 节点到基站的距离
           c=1; % 数组从1开始
           for s = 1:k
               d2= sqrt((O(BGT(s)).xd - sink.x)^2 + (O(BGT(s)).yd - sink.y)^2);  % 簇头到基站的距离
               d3 = sqrt((O(BGT(s)).xd - O(cunhuo(i)).xd)^2 + (O(BGT(s)).yd - O(cunhuo(i)).yd)^2);  % 节点到簇头的距离
               if d1>(d2/2)&&d1>d3     % 选择节点的预选簇头并放入YCH向量中(节点到基站要大于簇头到基站和要大于节点到簇头）
                  YCH(c) = BGT(s);
                  c=c+1;
               end
           end
           z = length(YCH);  % 获取向量YCH的列数
           if z ~= 0
              fd3 = []; % 定义空向量放置节点到所有预选簇头的距离
              CH = 0; % 假设初始时CH为0
              for rc = 1:z
                  d3 = sqrt((O(YCH(rc)).xd - O(cunhuo(i)).xd)^2 + (O(YCH(rc)).yd - O(cunhuo(i)).yd)^2);  % 节点到预先簇头的距离
                  Ech = 1/(O(YCH(rc)).E);  % 预选簇头的能量
                  q4 = 0.4;  %  节点到预选簇头的权值
                  q5 = 0.6;  %  预选簇头能量的权值
                  xch = q4*d3 + q5*Ech; % 选取簇头时的适应度函数
                  fd3(rc) = xch;  % 适应度函数值放入空向量中
                  minD = min(fd3); % 找最小适应度函数
                  CHwz = find(fd3 == minD); % 最小距离的节点在fd3中的位置
                  CH = YCH(CHwz);  % 在fd3中提取出距离最小位置的节点CH即簇头
              end
              qishin = cunhuo(i);
              while all(O(qishin).xd ~= O(CH).xd)&&all(O(qishin).yd ~= O(CH).yd)   % 判断是否到达CH
              % 选取邻居节点
              YCH = []; % 每次更新为空向量，来放置满足d1>d2的节点
              d1 =  sqrt((O(qishin).xd - O(CH).xd)^2 + (O(qishin).yd - O(CH).yd)^2);   % 起始节点到CH的距离
              c = 1;
              for cei = 1:numcunhuo
                  if O(cunhuo(cei)).E>0  % 判断节点是否有能量
                     d2 = sqrt((O(cunhuo(cei)).xd - O(CH).xd)^2 + (O(cunhuo(cei)).yd - O(CH).yd)^2);  % 所有节点到CH的距离
                     if d1>d2 % 选择节点并放入YCH向量中
                        YCH(c) = cunhuo(cei);
                        c=c+1;
                     end
                  end
              end
            linjv = []; % 每次更新为空向量，来放置满足d3<d1的节点
            p = length(YCH);
            x = 1;
            if p~=0
               for q = 1:p
                   d3 = sqrt((O(YCH(q)).xd - O(qishin).xd)^2 + (O(YCH(q)).yd - O(qishin).yd)^2);   % 起始节点到预选跳转节点的距离
                   if d3<d1 % 满足第二个条件的节点并放入linjv向量中
                      linjv(x) = YCH(q);
                      x=x+1;
                   end
               end
            else %  判断YCH是否为空如果为空直接到CH
               qiji =  sqrt((O(qishin).xd - O(CH).xd)^2 + (O(qishin).yd - O(CH).yd)^2); % 起始节点直接到CH
               O(CH).E = O(CH).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
               if (qiji > do) % 向簇头发送数据包
                  O(qishin).E = O(qishin).E - (ETX*packetLength + Emp * packetLength*qiji^4);
               else
                  O(qishin).E = O(qishin).E - (ETX*packetLength + Efs * packetLength*qiji^2);
               end
               break;   % while循环停止条件
            end  
          % 判断邻居节点
            m = length(linjv);
            if m~=0  % 判断linjv是否为空
               shiyingdu = [];
               q1 = 0.6;
               q2 = 0.4;
               for z = 1:m
                   d4 = sqrt((O(qishin).xd - O(linjv(z)).xd)^2 + (O(qishin).yd - O(linjv(z)).yd)^2); % 起始节点到预选跳转节点的距离
                   lE = O(linjv).E;
                   fitchuanshu = q1*d4+q2*(1/lE);
                   shiyingdu(z) = fitchuanshu;
               end
              minD = min(shiyingdu); % 找最小值
              TZshiying = find(shiyingdu == minD); % 最小适应度在全部邻居节点适应度中的位置
              TZnode = linjv(TZshiying);  % 在邻居中提取出适应度最小的即跳转节点TZnode
              O(TZnode).E = O(TZnode).E - (ERX*packetLength); % 下一跳节点接收数据
              qitiao = sqrt((O(qishin).xd - O(TZnode).xd)^2 + (O(qishin).yd - O(TZnode).yd)^2); % 起始节点到跳转节点的距离
              if (qitiao > do) % 向下一跳发送数据包
                 O(qishin).E = O(qishin).E - (ETX*packetLength + Emp * packetLength*qitiao^4);       
              else
                 O(qishin).E = O(qishin).E - (ETX*packetLength + Efs * packetLength*qitiao^2);
              end
           else  % 判断linjv是否为空如果为空直接到CH
              qiji =  sqrt((O(qishin).xd - O(CH).xd)^2 + (O(qishin).yd - O(CH).yd)^2); % 起始节点直接到CH
              O(CH).E = O(CH).E - ((ERX + EDA)*packetLength ); %接受簇成员发来的数据包
              if (qiji > do) % 向簇头发送数据包
                  O(qishin).E = O(qishin).E - (ETX*packetLength + Emp * packetLength*qiji^4);
              else
                  O(qishin).E = O(qishin).E - (ETX*packetLength + Efs * packetLength*qiji^2);
              end 
              break;  % while循环停止条件
           end
           qishin = TZnode; % 起始节点开始前进
           if all(O(qishin).xd == O(CH).xd)&&all(O(qishin).yd == O(CH).yd) 
              qiji =  sqrt((O(qishin).xd - O(CH).xd)^2 + (O(qishin).yd - O(CH).yd)^2); % 起始节点直接到CH
              O(CH).E = O(CH).E - ((ERX + EDA)*packetLength ); %接受簇成员发来的数据包
              if (qiji > do) % 向簇头发送数据包
                 O(qishin).E = O(qishin).E - (ETX*packetLength + Emp * ctrPacketLength*qiji^4);
              else
                 O(qishin).E = O(qishin).E - (ETX*packetLength + Efs * ctrPacketLength*qiji^2);
              end
              break;   % while循环停止条件
           end
              end   % 判断是否到达CH
           else
              putong(pt) = cunhuo(i);   % 普通节点存储到putong向量中
              pt = pt+1;
           end
        end  % 判断节点是否为簇头节点
        end % 判断节点是否有能量
    end   % 所有节点入簇
    buneng = [];
    else
        buneng = cunhuo; % 存活节点不足形成种群时直接传输
        BestX = [];
        putong = [];
    end
%%  5、数据传输  
    qishijiedian = horzcat(BestX, putong,buneng); %  向量合并为所有起始节点的合集BestX向量为簇头节点，putong向量为直接节点 
    changdu = length(qishijiedian);  %  所有起始节点的个数
    for CS = 1:changdu   % 所有起始节点开始传输
       % 初始化
        qishi = qishijiedian(CS);
        while all(O(qishi).xd ~= O(n+1).xd)&&all(O(qishi).yd ~= O(n+1).yd)   % 判断是否到达基站
       % 选取邻居节点
              YCH = []; % 每次更新为空向量，来放置满足d1>d2的节点
              d1 =  sqrt((O(qishi).xd - sink.x)^2 + (O(qishi).yd - sink.y)^2);   % 起始节点到基站的距离
              c = 1;
              for i = 1:numcunhuo
                  if O(cunhuo(i)).E>0  % 判断节点是否有能量
                     d2 = sqrt((O(cunhuo(i)).xd - sink.x)^2 + (O(cunhuo(i)).yd - sink.y)^2);  % 所有节点到基站的距离
                     if d1>d2 % 选择节点并放入YCH向量中
                        YCH(c) = cunhuo(i);
                        c=c+1;
                     end
                  end
              end
              linjv = []; % 每次更新为空向量，来放置满足d3<d1的节点
              p = length(YCH);
              x = 1;
              if p~=0
                 for q = 1:p
                     d3 = sqrt((O(YCH(q)).xd - O(qishi).xd)^2 + (O(YCH(q)).yd - O(qishi).yd)^2);   % 起始节点到预选跳转节点的距离
                     if d3<d1 % 满足第二个条件的节点并放入linjv向量中
                        linjv(x) = YCH(q);
                        x=x+1;
                     end
                 end
              else %  判断YCH是否为空如果为空直接到基站
                 qiji =  sqrt((O(qishi).xd - sink.x)^2 + (O(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Emp * packetLength*qiji^4);
                 else
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Efs * packetLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和基站的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和基站的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end  
          % 判断邻居节点
              m = length(linjv);
              if m~=0  % 判断linjv是否为空
                 shiyingdu = [];
                 for z = 1:m
                     q1 = 0.55;   % 权值
                     q2 = 0.3;   % 权值
                     q3 = 0.15;   % 权值
                     d4 = sqrt((O(qishi).xd - O(linjv(z)).xd)^2 + (O(qishi).yd - O(linjv(z)).yd)^2); % 起始节点到预选跳转节点的距离
                     d5 = sqrt((O(linjv(z)).xd - sink.x)^2 + (O(linjv(z)).yd - sink.y)^2);        % 预选跳转节点到簇头的距离
                     fitchuanshu = q1*(1/(O(linjv(z)).E))+q2*d4+q3*d5;
                     shiyingdu(z) = fitchuanshu;
                 end
                 minD = min(shiyingdu); % 找最小值
                 TZshiying = find(shiyingdu == minD); % 最小适应度在全部邻居节点适应度中的位置
                 TZnode = linjv(TZshiying);  % 在邻居中提取出适应度最小的即跳转节点TZnode
                 O(TZnode).E = O(TZnode).E - (ERX*packetLength); % 下一跳节点接收数据
                 qitiao = sqrt((O(qishi).xd - O(TZnode).xd)^2 + (O(qishi).yd - O(TZnode).yd)^2); % 起始节点到跳转节点的距离
                 if (qitiao > do)
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Emp * packetLength*qitiao^4);
                 else
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Efs * packetLength*qitiao^2);
                 end
                 %CHU = [S(qishi).xd,S(TZnode).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(TZnode).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
              else  % 判断linjv是否为空如果为空直接到基站
                 qiji =  sqrt((O(qishi).xd - sink.x)^2 + (O(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Emp * packetLength*qiji^4);
                 else
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Efs * packetLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取转发点和终点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取转发点和终点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;  % while循环停止条件
              end
              qishi = TZnode; % 起始节点开始前进
              if all(O(qishi).xd == O(n+1).xd)&&all(O(qishi).yd == O(n+1).yd) 
                 qiji =  sqrt((O(qishi).xd - sink.x)^2 + (O(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Emp * packetLength*qiji^4);
                 else
                    O(qishi).E = O(qishi).E - ( ETX*packetLength + Efs * packetLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end
         end   % 判断是否到达基站
     end % 全部数据点
     disp(r);
end % 主循环
%% 三、网络运行模块(CGWOA)
% 死亡节点数
dead2 = 0; % 死亡节点数目
first_dead2 = 0;%第一个死亡节点
teenth_dead2 = 0;%10%的死亡节点
all_dead2 = 0;%节点都死亡
%标记
flag_first_dead2 = 0;
flag_teenth_dead2 = 0;
flag_all_dead2 = 0;
% % 传输到基站和簇头的比特计数器
% packets_TO_BS = 0;
% packets_TO_CH = 0;
for r = 0:rmax % 主循环
    energy2 = 0;% 每轮节点剩余总能量
    cun = 1;
    cunhuo = [];
    for Ei = 1:n   % 所有节点进行判断
        if CG(Ei).E>0  % 判断存活节点是否为0
            cunhuo(cun) = Ei;
            cun = cun + 1;
        end
    end
    numcunhuo = length(cunhuo);
    dead2 = n - numcunhuo;
    % (3)第一个死亡节点的产生时间(用轮次表示)
    % 第一个节点死亡时间
    if dead2 == 1
       if flag_first_dead2 == 0
          first_dead2 = r;
          flag_first_dead2 = 1;
       end
    end
    % 10%的节点死亡时间
    if dead2 == 0.1*n
       if flag_teenth_dead2 ==0
          teenth_dead2 = r;
          flag_teenth_dead2 = 1;
       end
    end
    if dead2 == n
       if flag_all_dead2 == 0
          all_dead2 = r;
          flag_all_dead2 = 1;
       end
    end
    for sw = 1:numcunhuo
        if CG(cunhuo(sw)).E > 0
           energy2 = energy2 + CG(cunhuo(sw)).E;%统计每轮节点总能量和
        end
    end
     STATISTICS2.DEAD(r+1) = dead2;
     STATISTICS2.alive(r+1) = numcunhuo;
     STATISTICS2.energy(r+1) = energy2;
    cluster = 0;%计数簇头数
%%  1、为优化算法生成种群
    if length(cunhuo) >20
originalArray = cunhuo;  %  n个节点按顺序组成的数组
k = ceil(numcunhuo*chp);  % 最优簇头数(根据LEACH协议论文中） 向上取整
num_zhongqun = 30;  % 种群个体数量规模(偶数）
PopPos = [];   % 种群allSelections矩阵
for gm = 1:num_zhongqun  % 从N个节点中随机选取其中K个共进行200次，生成种群规模
    selectedNumbers = originalArray(randperm(length(originalArray), k));  % 在originalArry中随机选取K个数并赋值给selectedNumbers数组
    PopPos = [PopPos;selectedNumbers];  % 将selectedNumbers数组放入种群PopPos矩阵中
end
%%  4、通过优化算法在种群中找到最优的结果
PopFit = fitcgwoa(PopPos,CG,num_zhongqun,k);  % 初始化种群的调用适应度函数计算适应度
BestF=inf;  % 将BestF（最优适应度值）初始化为无穷大（inf）
BestX=[];  % 将BestX（最优解的位置）初始化为空数组。
    % for i=1:nPop：这是一个 for 循环，它从 1 遍历到 nPop，其中 nPop 是种群的大小，即种群中个体的数量。
    % if PopFit(i) <= BestF：这是一个 if 条件语句，它检查当前个体的适应度值 PopFit(i) 是否小于或等于当前记录的最优适应度 BestF。
    % BestF=PopFit(i);：如果当前个体的适应度值更好（即更小，因为我们通常希望最小化适应度函数），则更新 BestF 为这个新的适应度值。
    % BestX=PopPos(i,:);：同时，将当前个体的位置 PopPos(i,:) 赋值给 BestX，这样 BestX 就保存了当前最优解的位置。
for q = 1:num_zhongqun   % 将初始化种群的结果最好的保留在BestF和BestX中
    if PopFit(q)<=BestF 
       BestF=PopFit(q);
       BestX=PopPos(q,:);
    end
end
%%   5、CGWOA算法选出簇头
numdiedai = 30; % CGWOA算法迭代次数………………………………
for Dd = 1:numdiedai  % CGWOA算法迭代次数
    Ga = 2-2*(Dd/numdiedai);
    GA1 = 2*Ga*rand(1)-Ga;GA2 = 2*Ga*rand(1)-Ga;GA3 = 2*Ga*rand(1)-Ga;
    GC1 = 2*rand(1);GC2 = 2*rand(1);GC3 = 2*rand(1);
    % 计算每个元素的值和它们的索引
    [val, idx] = sort(PopFit);
    % 选择最小的三个值及其索引
    min_three_vals = val(1:3);
    min_three_positions = idx(1:3);
    % 输出结果
    %disp(['最小的三个值是: ', num2str(min_three_vals)]);
    %disp(['这些值在向量中的位置是: ', num2str(min_three_positions)]);
    for Ggengxin = 1:num_zhongqun
        if Ggengxin ~= idx
           LWX = PopPos(Ggengxin,:);
           GX1 = idx(1);GX2 = idx(2);GX3 = idx(3);
           Gx1=PopPos(GX1,:)-GA1*abs(GC1*PopPos(GX1,:)-LWX);
           Gx2=PopPos(GX2,:)-GA2*abs(GC2*PopPos(GX2,:)-LWX);
           Gx3=PopPos(GX3,:)-GA3*abs(GC3*PopPos(GX3,:)-LWX);
           GXT = (Gx1+Gx2+Gx3)/3;
           GXT(1) = ceil(0.7*(GXT(1)-1));
           GXT(2) = ceil(0.7*(GXT(2)-1));
           GXT(3) = ceil(0.7*(GXT(3)-1));
           GTx = unique(GTX);
           cgwoad = length(GTx);
           if cgwoad ~= 5
              bcg = randi(numcunhuo);
              cun = cunhuo(bcg);
           end
           GTx(end+1) = cun;
           GTX = GTx;
           PopPos(Ggengxin,:) = GTX;
        end
    end
    PopFit = fitcgwoa(PopPos,CG,num_zhongqun,k);  % 更新后种群的调用适应度函数计算适应度
    for newq = 1:num_zhongqun   % 将新种群的结果与上次种群的BeatF和BestX进行对比并最好的保留在BestF和BestX中
        if PopFit(newq)<=BestF 
           BestF=PopFit(newq);
           BestX=PopPos(newq,:);
        end
    end  
end % 迭代次数
BGT=BestX;  % 获取最优个体即簇头
%disp(BGT);  % 输出簇头￥￥￥￥￥￥
   %基站广播簇头，所有节点接收
   for gb = 1:numcunhuo
       CG(cunhuo(gb)).E = CG(cunhuo(gb)).E - ERX * ctrPacketLength;
   end
%%  4、普通节点入簇
   pt = 1;
   putong = [];  % 直接传输给基站的普通节点需要一直存储所以不能再循环中不然会变为空向量
   for i =1:numcunhuo % 存活节点选择簇头
       if CG(cunhuo(i)).E>0 % 判断节点是否有能量
          if cunhuo(i) ~= BGT  % 簇头节点不进行入簇
                cgfd3 = [];
                for rc = 1:length(BGT)
                    cgd3 = sqrt((CG(BGT(rc)).xd - CG(cunhuo(i)).xd)^2 + (CG(BGT(rc)).yd - CG(cunhuo(i)).yd)^2);  % 节点到预先簇头的距离
                    cgfd3(rc) = cgd3;  % 适应度函数值放入空向量中
                    cgminD = min(cgfd3); % 找最小适应度函数
                    cgCHwz = find(cgfd3 == cgminD); % 最小距离的节点在fd3中的位置
                    CH = BGT(cgCHwz);  % 在fd3中提取出距离最小位置的节点CH即簇头
                end
                disjc = sqrt((CG(CH).xd - CG(cunhuo(i)).xd)^2 + (CG(CH).yd - CG(cunhuo(i)).yd)^2);    % 节点到簇头的距离
              %向簇头发送加入消息、向簇头发送数据包
                if (disjc > do)
                    CG(cunhuo(i)).E = CG(cunhuo(i)).E - ( ETX*packetLength + Emp*packetLength*disjc^4); %向簇发送头数据包
                else
                   CG(cunhuo(i)).E = CG(cunhuo(i)).E - ( ETX*packetLength + Efs*packetLength*disjc^2); %向簇头发送数据包
                end
              %接收簇头确认加入控制消息
                CG(cunhuo(i)).E = CG(cunhuo(i)).E - ERX*ctrPacketLength;
              %簇头接收簇成员的加入消息和数据包，簇头向簇成员发送确认加入的信息
                if(disjc > 0)
                   CG(CH).E = CG(CH).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
                end
              %CHU = [S(i).xd,S(CH).xd];  % 获取起点和终点的横坐标
              %DAO = [S(i).yd,S(CH).yd];  % 获取起点和终点的纵坐标
              %plot(CHU,DAO,'b-');  % 画出节点入簇的线段 
          end  % 判断节点是否为簇头节点
       end % 判断节点是否有能量
    end   % 所有节点入簇
    buneng = [];
    else
        buneng = cunhuo; % 存活节点不足形成种群时直接传输
        BestX = [];
    end
%%  5、数据传输  
    qishijiedian = horzcat(BestX,buneng); %  向量合并为所有起始节点的合集BestX向量为簇头节点，putong向量为直接节点 
    changdu = length(qishijiedian);  %  所有起始节点的个数
    for CS = 1:changdu   % 所有起始节点开始传输
       % 初始化
        qishi = qishijiedian(CS);
        while all(CG(qishi).xd ~= CG(n+1).xd)&&all(CG(qishi).yd ~= CG(n+1).yd)   % 判断是否到达基站
       % 选取邻居节点
              YCH = []; % 每次更新为空向量，来放置满足d1>d2的节点
              d1 =  sqrt((CG(qishi).xd - sink.x)^2 + (CG(qishi).yd - sink.y)^2);   % 起始节点到基站的距离
              c = 1;
              for i = 1:numcunhuo
                  if CG(cunhuo(i)).E>0  % 判断节点是否有能量
                     d2 = sqrt((CG(cunhuo(i)).xd - sink.x)^2 + (CG(cunhuo(i)).yd - sink.y)^2);  % 所有节点到基站的距离
                     if d1>d2 % 选择节点并放入YCH向量中
                        YCH(c) = cunhuo(i);
                        c=c+1;
                     end
                  end
              end
              linjv = []; % 每次更新为空向量，来放置满足d3<d1的节点
              p = length(YCH);
              x = 1;
              if p~=0
                 for q = 1:p
                     d3 = sqrt((CG(YCH(q)).xd - CG(qishi).xd)^2 + (CG(YCH(q)).yd - CG(qishi).yd)^2);   % 起始节点到预选跳转节点的距离
                     if d3<d1 % 满足第二个条件的节点并放入linjv向量中
                        linjv(x) = YCH(q);
                        x=x+1;
                     end
                 end
              else %  判断YCH是否为空如果为空直接到基站
                 qiji =  sqrt((CG(qishi).xd - sink.x)^2 + (CG(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Emp * packetLength*qiji^4);
                 else
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Efs * packetLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和基站的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和基站的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end  
          % 判断邻居节点
              m = length(linjv);
              if m~=0  % 判断linjv是否为空
                 shiyingdu = [];
                 for z = 1:m
                     fitchuanshu = (1/(CG(linjv(z)).E));
                     shiyingdu(z) = fitchuanshu;
                 end
                 minD = min(shiyingdu); % 找最小值
                 TZshiying = find(shiyingdu == minD); % 最小适应度在全部邻居节点适应度中的位置
                 TZnode = linjv(TZshiying);  % 在邻居中提取出适应度最小的即跳转节点TZnode
                 CG(TZnode).E = CG(TZnode).E - (ERX*packetLength); % 下一跳节点接收数据
                 qitiao = sqrt((CG(qishi).xd - CG(TZnode).xd)^2 + (CG(qishi).yd - CG(TZnode).yd)^2); % 起始节点到跳转节点的距离
                 if (qitiao > do)
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Emp * packetLength*qitiao^4);
                 else
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Efs * packetLength*qitiao^2);
                 end
                 %CHU = [S(qishi).xd,S(TZnode).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(TZnode).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
              else  % 判断linjv是否为空如果为空直接到基站
                 qiji =  sqrt((CG(qishi).xd - sink.x)^2 + (CG(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Emp * packetLength*qiji^4);
                 else
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Efs * packetLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取转发点和终点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取转发点和终点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;  % while循环停止条件
              end
              qishi = TZnode; % 起始节点开始前进
              if all(CG(qishi).xd == CG(n+1).xd)&&all(CG(qishi).yd == CG(n+1).yd) 
                 qiji =  sqrt((CG(qishi).xd - sink.x)^2 + (CG(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Emp * packetLength*qiji^4);
                 else
                    CG(qishi).E = CG(qishi).E - ( ETX*packetLength + Efs * packetLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end
         end   % 判断是否到达基站
     end % 全部数据点
     disp(r);
end % 主循环
%% 3、网络运行模块(LEACH)

% 死亡节点数
dead = 0;
first_dead = 0;%第一个死亡节点
teenth_dead = 0;%10%的死亡节点
all_dead = 0;%节点都死亡
%标记
flag_first_dead = 0;
flag_teenth_dead = 0;
flag_all_dead = 0;

% 传输到基站和簇头的比特计数器
packets_TO_BS = 0;
packets_TO_CH = 0;
% 主循环 
for r = 0:rmax 
    %每过一轮周期，重置G
    if(mod(r, round(1/chp) ) == 0)
        for i = 1:n
            S(i).G = 0;
        end
    end
    dead = 0;
    energy = 0;% 每轮节点剩余总能量
    for i = 1:n
        % 检查有无死亡节点
        if S(i).E <= 0
            dead = dead+1;
            % (3)第一个死亡节点的产生时间(用轮次表示)
            % 第一个节点死亡时间
            if dead == 1
                if flag_first_dead == 0
                    first_dead = r;
                    flag_first_dead = 1;
                end
            end
            % 10%的节点死亡时间
            if dead == 0.1*n
                if flag_teenth_dead ==0
                    teenth_dead = r;
                    flag_teenth_dead = 1;
                end
            end
            if dead == n
                if flag_all_dead == 0
                    all_dead = r;
                    flag_all_dead = 1;
                end
            end
        end
        if S(i).E > 0
            energy = energy + S(i).E;%统计每轮节点总能量和
            S(i).type = 'N';
        end
    end
%     if flag_all_dead == 1
%         break;
%     end
    STATISTICS.DEAD(r+1) = dead;
    STATISTICS.alive(r+1) = n-dead;
    STATISTICS.energy(r+1) = energy;
    cluster = 0;%计数簇头数
    %次循环(选簇头)
    if energy > 0%这个判断可以很大程度优化程序，当网络没有能量时，后面的都不用再运行了
        for i=1:n
            if(S(i).E>0)
                temp_rand=rand;     
                if ( (S(i).G)<=0) %如果该节点在候选集合中
                    %选簇头
                    if( temp_rand <= (chp/(1-chp*mod(r,round(1/chp)))))
                        cluster = cluster+1;
                        S(i).type = 'C';
                        S(i).G = round(1/chp)-1;
                        C(cluster).xd = S(i).xd;
                        C(cluster).yd = S(i).yd;
                        distance=sqrt( (S(i).xd-(S(n+1).xd) )^2 + (S(i).yd-(S(n+1).yd) )^2 );%到sink的距离
                        C(cluster).distance = distance;
                        C(cluster).id = i;
                        distanceBroad = sqrt(xm^2+ym^2);
                        %全网广播自成为簇头,距离是distanceBroad
                        if (distanceBroad > do)
                            S(i).E = S(i).E- ( ETX * ctrPacketLength + Emp* ctrPacketLength*distanceBroad^4);
                        else
                            S(i).E = S(i).E- ( ETX * ctrPacketLength + Efs * ctrPacketLength*distanceBroad^2); 
                        end
                        %簇头向基站发送数据包能耗
                        if (distance > do)
                            S(i).E = S(i).E- ( (ETX+EDA)*packetLength + Emp * packetLength*distance^4);
                        else
                            S(i).E = S(i).E- ( (ETX+EDA)*packetLength + Efs * packetLength*distance^2); 
                        end
                        packets_TO_BS = packets_TO_BS + 1;
                    end     
                end
            end
        end 
    end
    STATISTICS.COUNTCHS(r+1) = cluster;
    %次循环(成簇)
    if energy > 0
        for i = 1:n
            if ( S(i).type=='N' && S(i).E>0 ) %普通节点
                if(cluster>= 1)%如果有簇头存在
                    lengt = zeros(cluster,1);
                    %加入最近的簇头
                    for c = 1:cluster
                        lengt(c) = sqrt( (S(i).xd - C(c).xd)^2 + (S(i).yd - C(c).yd)^2 );
                        %接收簇头发来的广播的消耗
                        S(i).E = S(i).E - ERX * ctrPacketLength;
                    end
                    [min_dis, min_dis_cluster] = min(lengt);%min_dis返回最短距离，min_dis_cluster返回最短距离对应的簇号
                    %向簇头发送加入消息、向簇头发送数据包
                    if (min_dis > do)
                        S(i).E = S(i).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*min_dis^4); %向簇头发送加入控制消息
                        S(i).E = S(i).E - ( ETX*packetLength + Emp*packetLength*min_dis^4); %向簇发送头数据包
                    else
                        S(i).E = S(i).E - ( ETX*ctrPacketLength + Efs*ctrPacketLength*min_dis^2); %向簇头发送加入控制消息
                        S(i).E = S(i).E - ( ETX*packetLength + Efs*packetLength*min_dis^2); %向簇头发送数据包
                    end
                    %接收簇头确认加入控制消息
                    S(i).E = S(i).E - ERX*ctrPacketLength;
                    %簇头接收簇成员的加入消息和数据包，簇头向簇成员发送确认加入的信息
                    if(min_dis > 0)
                        S(C(min_dis_cluster).id).E = S(C(min_dis_cluster).id).E - ERX *ctrPacketLength ;%接收加入消息
                        S(C(min_dis_cluster).id).E = S(C(min_dis_cluster).id).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
                        %簇头向簇成员发送确认加入的信息
                        if (min_dis > do)
                            S(C(min_dis_cluster).id).E = S(C(min_dis_cluster).id).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*min_dis^4);
                        else
                            S(C(min_dis_cluster).id).E = S(C(min_dis_cluster).id).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*min_dis^2);
                        end
                    end
                    S(i).min_dis = min_dis;
                    S(i).min_dis_cluster = min_dis_cluster;
                    packets_TO_CH = packets_TO_CH + 1;
                else%如果本轮没有簇头，则普通节点直接将数据直接发送给基站
                    min_dis = sqrt((S(i).xd-S(n+1).xd)^2 + (S(i).yd-S(n+1).yd)^2);
                    if min_dis > do
                        S(i).E = S(i).E- (ETX*packetLength + Emp*packetLength*min_dis^4);
                    else
                        S(i).E = S(i).E- (ETX*packetLength + Efs*packetLength*min_dis^2);
                    end
                    packets_TO_BS = packets_TO_BS+1;
                end
            end
        end
    end
    STATISTICS.PACKETS_TO_CH(r+1) = packets_TO_CH;
    STATISTICS.PACKETS_TO_BS(r+1) = packets_TO_BS;
end
%% 3、PSO参数(PSO_C)
MaxIter = 50;      % 最大迭代次数
nPop = 30;        % 种群规模
wmax = 0.9;
wmin = 0.4;
w = 1; 
c1 = 2.0;         % 个人学习系数
c2 = 2.0;         % 全局学习系数
plimit = [0, 200];                % 位置参数限制
vlimit = [-20, 20];               % 速度限制

%数据初始化
particle.Position = cell(1,nPop);
particle.Cost = zeros(1,nPop);
particle.Velocity = cell(1,nPop);
particle.Best.Position = cell(1,nPop);
particle.Best.Cost = ones(1,nPop)*inf;
GlobalBestCost = inf;
GlobalBestPosition = [];

%% 4、网络运行模块 
% 死亡节点数指标
first_dead4 = 0;%第一个死亡节点
teenth_dead4 = 0;%10%的死亡节点
all_dead4 = 0;%节点都死亡

%节点死亡数指标对应标记
flag_first_dead4 = 0;
flag_teenth_dead4 = 0;
flag_all_dead4 = 0;

%传输到基站和簇头的比特计数器
packets_TO_BS = 0;
packets_TO_CH = 0;

%主循环
for r = 0:rmax 
%     w = 1-0.5*(r/rmax);
%     w = 0.5+1*(r/rmax);
    dead4 = 0;%计算死亡节点数
    energy4 = 0;%每轮节点剩余总能量
    Node = [];%存活节点集合
    C = [];%候选节点集合
    j = 0;
    for i = 1:n
        %检查有无死亡节点
        if SO(i).E <= 0
            dead4 = dead4+1;
            %第一个节点死亡时间
            if dead4 == 1
                if flag_first_dead4 == 0
                    first_dead4 = r+1;
                    flag_first_dead4 = 1;
                end
            end
            % 10%的节点死亡时间
            if dead4 == 0.1*n
                if flag_teenth_dead4 ==0
                    teenth_dead4 = r+1;
                    flag_teenth_dead4 = 1;
                end
            end
            if dead4 == n
                if flag_all_dead4 == 0
                    all_dead4 = r+1;
                    flag_all_dead4 = 1;
                end
            end
        end
        if SO(i).E > 0
            energy4 = energy4 + SO(i).E;%统计每轮节点总能量和
            SO(i).type = 'N';
            j = j+1;
            Node(j,:) = [SO(i).xd SO(i).yd];%存活节点集合
        end
    end
    
    STATISTICS4.DEAD(r+1) = dead4;%每轮死亡节点数
    STATISTICS4.alive(r+1) = n-dead4;%每轮存活节点数
    STATISTICS4.energy(r+1) = energy4;%每轮剩余总能量
    
    if n-dead4 == 0
        STATISTICS4.COUNTCHS(r+1) = 0;
        continue;
    end
    
%% 4.1、应用PSO选簇头
    %候选簇头集合
    j = 0;
    for i = 1:n
        if r == 0 %因为matlab最大精度16位，后面数据不准，第一轮会出现这种情况，所以这样编程
            j = j+1;
            C.d(j,:) = [SO(i).xd SO(i).yd];%候选簇头坐标
            C.E(j) = SO(i).E;%候选簇头剩余能量
            C.id(j) = i;%候选簇头对应的节点编号
        else
            if SO(i).E >= energy4/(n-dead4) %节点能量大于或等于总的平均能量
                j = j+1;
                C.d(j,:) = [SO(i).xd SO(i).yd];%候选簇头坐标
                C.E(j) = SO(i).E;%候选簇头剩余能量
                C.id(j) = i;%候选簇头对应的节点编号
            end
        end
    end
    
    M = size(C.d,1);%候选簇头数
    K = ceil((n-dead4)*chp);% 簇头数
    if M < K
       K = M;
    end
    %初始化种群位置和速度
    for i = 1:nPop % nPop种群规模大小
        % 初始化位置
        C_k = randperm(M,K);
        particle.Position{i} = C.d(C_k,:);
    
        % 初始化速度
        v = zeros(K,2);
        particle.Velocity{i}=v;
    
        % 适应度
        energe_Q = sum(C.E((C_k)));
        isB = ismember(Node,particle.Position{i});
        Cluster_member = reshape(Node(~isB),[],2);%传感器簇成员节点矩阵
        particle.Cost(i)=Cost(Cluster_member,particle.Position{i},K,energy4,energe_Q);
    end
    
    Iter = 1;%计数
    while Iter <= MaxIter
        %更新粒子个体最佳适应度、位置   
        for i = 1:nPop      
           if particle.Cost(i) < particle.Best.Cost(i) 
               particle.Best.Cost(i) = particle.Cost(i);%更新个体历史最佳适应度
               particle.Best.Position{i} = particle.Position{i};%更新个体历史最佳位置
           end 
        end

        %更新群体最佳适应度、位置
        if min(particle.Best.Cost) < GlobalBestCost  
            [GlobalBestCost, index1] = min(particle.Best.Cost);%更新群体历史最佳适应度
            GlobalBestPosition = particle.Best.Position{index1};%更新群体历史最佳位置
        end

        % 速度更新
%         w = wmax-(wmax-wmin)*Iter/MaxIter;
%         w = wmax-(wmax-wmin)*(Iter/MaxIter)^2;
%         w = wmin+(wmax-wmin)*Iter/MaxIter;
%         w = wmin+(wmax-wmin)*(Iter/MaxIter)^2;
%         w = w-(w-wmin)*(Iter/MaxIter)^2;
        for i = 1:nPop 
            particle.Velocity{i} = particle.Velocity{i}.*w + c1*rand*(particle.Best.Position{i}-particle.Position{i}) ...
                + c2*rand*(GlobalBestPosition-particle.Position{i});% 速度更新
        end

        % 边界速度处理
        for i = 1:nPop 
            particle.Velocity{i}(particle.Velocity{i}>20) = 20;
            particle.Velocity{i}(particle.Velocity{i}<-20) = -20;
        end

        % 位置更新
        for i = 1:nPop 
            particle.Position{i} = particle.Position{i} + particle.Velocity{i};
        end

        % 边界位置处理
        for i = 1:nPop 
            particle.Position{i}(particle.Position{i}>200)=200;
            particle.Position{i}(particle.Position{i}<0)=0;
        end

        %根据距离最近候选簇头位置调整粒子位置,计算相应适应度
        for i = 1:nPop 
            distance = pdist2(C.d,particle.Position{i});
            [~, index2] = min(distance);
            particle.Position{i} = C.d(index2,:);

            % 适应度
            energe_Q = sum(C.E((index2)));
            isB = ismember(Node,particle.Position{i});
            Cluster_member = reshape(Node(~isB),[],2);%传感器簇成员节点矩阵
            particle.Cost(i)=Cost(Cluster_member,particle.Position{i},K,energy4,energe_Q);
        end
        Iter = Iter+1;
    end

    %根据距离最近候选簇头位置得到簇头信息
    distance = pdist2(C.d,GlobalBestPosition);
    minDistt = min(distance);
    [~, index2] = find(distance == minDistt);
    %如果簇头重复，需要调整
    length_index2 = length(unique(index2));
    cha = K-length_index2;%重复个数
    while cha ~= 0
        for i = 1:K-1
            for j = i+1:K
                if index2(i) == index2(j)
                    distance_cut = distance(:,j);%取distance的第j列
                    [~,Number] = sort(distance_cut);
                    Num = 1;
                    while length(unique(index2))~=K-(cha-1)  && Num<size(distance_cut,1)
                        Num = Num+1;
                        index2(j) = Number(Num);
                    end
                    cha = cha-1;
                end
            end
        end
    end

    %重置群体和个体最佳适应度、位置
    GlobalBestCost = inf;
    GlobalBestPosition = [];
    particle.Best.Cost = ones(1,nPop)*inf;
    particle.Best.Position = cell(1,nPop);

%% 4.2选总簇头
%     %确定簇头
%     for i = 1:K
%         j = C.id(index2(i));
%         S(j).type = 'C';
%     end
% 
%     Each_cluster = zeros(K,2);%第一列放每个簇的能量最大的节点的能量信息，第二列放节点标号,行对应簇号
% 
%     %预成簇
%     for i = 1:n
%         if ( S(i).type=='N' && S(i).E>0 ) %普通节点
%             %加入最近的簇头
%             distance_to_cluster = pdist2(C.d(index2,:),[S(i).xd S(i).yd]);
%             [min_dis, dis_index] = min(distance_to_cluster);%min_dis返回最短距离，dis_index返回最短距离对应的簇号
%             if S(i).E > Each_cluster(dis_index,1)
%                 Each_cluster(dis_index,1) = S(i).E;
%                 Each_cluster(dis_index,2) = i;
%             end 
%         end
%     end
% 
%     %若有空簇，将其候选总簇头节点假定为1
%     for i = 1:K
%         if Each_cluster(i,2) == 0
%             Each_cluster(i,2) = 1;
%         end
%     end
% 
%     %每个候选总簇头至所有簇头距离和
%     sum_distance_HCH_to_CH = sum(pdist2(C.d(index2,:),reshape([S(Each_cluster(:,2)).xd S(Each_cluster(:,2)).yd],[],2)));
%     %每个候选总簇头至基站距离
%     distance_HCH_to_BS = pdist2([S(n+1).xd S(n+1).yd],C.d(index2,:));
% 
%     CostofHCH = zeros(1,K);
%     for i = 1:K
%         CostofHCH(i) = Cost_HCH(Each_cluster(:,1),sum_distance_HCH_to_CH,distance_HCH_to_BS,i);
%     end
%     [~,index3] = min(CostofHCH);
%     S(Each_cluster(index3,2)).type = 'T';%总簇头
%% 4.3成簇，簇内通信
    for i = 1:n
        if ( SO(i).type=='N' && SO(i).E>0 ) %普通节点
            %加入最近的簇头
            distance_to_cluster = pdist2(C.d(index2,:),[SO(i).xd SO(i).yd]);
            [min_dis, dis_index] = min(distance_to_cluster);%min_dis返回最短距离，min_dis_cluster返回最短距离对应的簇号
            %向簇头发送数据包
            if (min_dis > do)
                SO(i).E = SO(i).E - ( ETX*packetLength + Emp*packetLength*min_dis^4); %向簇发送头数据包
            else
                SO(i).E = SO(i).E - ( ETX*packetLength + Efs*packetLength*min_dis^2); %向簇头发送数据包
            end
            %簇头接收簇成员的数据包
            if(min_dis > 0)
                SO(C.id(dis_index)).E = SO(C.id(dis_index)).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
            end
        end
    end
%% 4.4簇头和总簇头通信
    TCnumber = n+1;%总簇头编号
    for i = 1:K
        j = C.id(index2(i));
        SO(j).type = 'C';
        %簇头到总簇头的距离
        distance = sqrt((SO(j).xd-SO(TCnumber).xd)^2 + (SO(j).yd-(SO(TCnumber).yd))^2 );
        %簇头向基站发送数据包能耗
        if (distance > do)
            SO(j).E = SO(j).E- ( ETX * (packetLength) + Emp * packetLength*distance^4);
        else
            SO(j).E = SO(j).E- ( ETX * (packetLength) + Efs * packetLength*distance^2); 
        end
        %总簇头接收簇头的的数据包(不融合数据)
         if(distance > 0)
             SO(TCnumber).E = SO(TCnumber).E - ERX * packetLength; %接受簇头发来的数据包
         end
    end
 %% 4.5总簇头和基站通信
%      distance_to_BS = pdist2([S(n+1).xd S(n+1).yd],[S(TCnumber).xd S(TCnumber).yd]);
%      if (distance_to_BS > do)
%          S(TCnumber).E = S(TCnumber).E- (K * ETX * (packetLength) + Emp * packetLength*distance^4);
%     else
%          S(TCnumber).E = S(TCnumber).E- (K * ETX * (packetLength) + Efs * packetLength*distance^2); 
%     end
    STATISTICS.COUNTCHS(r+1) = K;
end
%% 绘图显示
figure;
plot(0:rmax, STATISTICS.DEAD, 'r',0:rmax, STATISTICS2.DEAD,'b',0:rmax, STATISTICS3.DEAD, 'm', 0:rmax, STATISTICS4.DEAD, 'g','LineWidth', 2);
xlabel('Number of rounds'); ylabel('Number of dead nodes');
legend('LEACH','CGWOA','CM-OOA','PSO-C')
figure;
plot(0:rmax, STATISTICS.alive, 'r',0:rmax, STATISTICS2.alive,'b',0:rmax, STATISTICS3.alive, 'm',0:rmax, STATISTICS4.alive, 'g', 'LineWidth', 2);
xlabel('Number of rounds'); ylabel('Number of active nodes');
legend('LEACH','CGWOA','CM-OOA','PSO-C')
figure;
plot(0:rmax, STATISTICS.energy, 'r',0:rmax, STATISTICS2.energy,'b',0:rmax, STATISTICS3.energy, 'm',0:rmax, STATISTICS4.energy, 'g', 'LineWidth', 2);
xlabel('Number of rounds'); ylabel('Dump energy');
legend('LEACH','CGWOA','CM-OOA','PSO-C')  
figure;
    %% 适应值函数(OOA)
% PopPos 是一个矩阵，其中每一行代表一个个体的位置。
% Dim 是最优簇头的数量，也是适应度函数的维度。PopFit 是一个向量，用于存储每个个体的适应度值。
function Fit = fitooa(swq,d,num_zhongqun,k,n,cunhuo) 
nPop = num_zhongqun;   % 种群数量
Dim = k;  % 适应值函数的维度即最优簇头数
    Fit=zeros(1,nPop);   % 创建一个 1 行 nPop 列的列向量，所有元素都是 0。这个向量用于存储种群中每个个体的适应度值。
    for w = 1:nPop     % 循环提取种群PopPos矩阵中个体
        geti = swq(w, :);   % 从 PopPos 矩阵中提取第w行个体的所有数据。                                             
        for h = 1:Dim  % Dim为最优簇头数目
            %for e = 1:Dim  % Dim为最优簇头数目
            for v = 1:n  % n为场地中节点数目
                disNC = 0;  % 初始化距离和
                disNCone = sqrt((d(geti(h)).xd - d(cunhuo(v)).xd)^2 + (d(geti(h)).yd - d(cunhuo(v)).yd)^2);  % 簇首h与每个节点之间的距离
                disNC = disNC + disNCone;  % 各个簇首与每个节点之间的距离的累加和
            end
            cfchbs = 1;
            chbsd = 0;
            chbsdone = sqrt((d(geti(h)).xd - d(n+1).xd)^2 + (d(geti(h)).yd - d(n+1).yd)^2);  % 一个簇首到基站的距离
            chbsd = chbsd + chbsdone;
            chd(cfchbs) = chbsdone;
            cfchbs = cfchbs + 1;
            EaLL = 0;
            EaLL = EaLL + d(geti(h)).E;  % 个体总能量
%             GaLL = 0;
%             GaLL = GaLL + d(geti(h)).G;  % 个体总次数
        end
        fangchachbs = var(chd); % 簇首到基站距离的方差
        cfchch = 1;
        for o = 1:Dim-1  % Dim为最优簇头数目
            for l = o+1:Dim
                disNN = 0;  % 初始化距离和
                disNNone = sqrt((d(geti(o)).xd - d(geti(l)).xd)^2 + (d(geti(o)).yd - d(geti(l)).yd)^2);  % 簇首h与其他簇首的距离
                disNN = disNN + disNNone;  % 各个簇首之间的距离的累加和
                chchd(cfchch) = disNNone;
                cfchch = cfchch + 1;
            end
        end
        fangchachch = var(chchd);  % 簇首到簇首距离的方差
        q1 = 0.12; % 权重能量
        %q2 = 0.07; % 权重次数
        q3 = 0.18; % 权重簇首之间的距离和
        q4 = 0.11; % 权重簇首到基站
        q5 = 0.15; % 权重簇首到节点距离
        q6 = 0.22; % 簇首到基站的距离方差
        q7 = 0.22; % 簇首到簇首的距离方差
        onePopFit = q1*(1/EaLL)+q3*(1/disNN)+q4*chbsd+q5*disNC+q6*fangchachbs+q7*fangchachch;
        Fit(w) = Fit(w) + onePopFit;  % 适应值函数设计
    end
end
%% 圆对称性混沌映射
function [Xnew, Ynew] = chaotic_map(x, y, zr, a)
    % zr 是圆的半径
    % a 是Logistic映射的参数，通常 a 在 (3, 4) 范围内可以产生混沌行为
    % 由于混沌特性仅通过一个参数引入，这里简化为只有一个参数 a

    % 计算极角
    theta = atan2(y-100, x-100);
    
    % 应用Logistic映射引入混沌特性
    % 首先，根据当前点的极角theta和圆的半径r计算Logistic映射的初始值
    z = zr * (1 - cos(theta));  % 将极角转换为Logistic映射的初始值
    
    % 进行一次Logistic映射迭代以引入混沌特性
    z = zr * a * (1 - a * z);  % Logistic映射公式
    
    % 将Logistic映射的结果转换回极坐标形式
    % 这里使用z的值来确定新的极角，而半径保持不变
    theta_new = asin(z / zr);  % 反变换，得到新的极角
    
    % 计算映射后的直角坐标系中的坐标
    Xnew = zr * cos(theta_new);
    Ynew = zr * sin(theta_new);
end
%% 适应值函数(CGWOA)
% PopPos 是一个矩阵，其中每一行代表一个个体的位置。
% Dim 是最优簇头的数量，也是适应度函数的维度。PopFit 是一个向量，用于存储每个个体的适应度值。
function Fit = fitcgwoa(swq,d,num_zhongqun,k) 
nPop = num_zhongqun;   % 种群数量
Dim = k;  % 适应值函数的维度即最优簇头数
Fit=zeros(1,nPop);   % 创建一个 1 行 nPop 列的列向量，所有元素都是 0。这个向量用于存储种群中每个个体的适应度值。
for w = 1:nPop     % 循环提取种群PopPos矩阵中个体
    geti = swq(w, :);   % 从 PopPos 矩阵中提取第w行个体的所有数据。
    Cgwoae = 0;
    disNC = 0;  % 初始化距离和
    for h = 1:Dim
        for o = 1:Dim  % Dim为最优簇头数目
            Cgwoae = d(geti(o)).E + Cgwoae;
        end
        for e = 1:Dim  % Dim为最优簇头数目
            disNCone = sqrt((d(geti(e)).xd - d(101).xd)^2 + (d(geti(e)).yd - d(101).yd)^2);  % 簇首h与每个节点之间的距离
            disNC = disNC + disNCone;  % 各个簇首与每个节点之间的距离的累加和
        end 
    end
    q1 = 0.5; % 能量权重
    q2 = 0.3; % 距离权重
    q3 = 0.2; % 节点度权重
    onePopFit = q1*(1/Cgwoae)+q2*disNC+q3*95;
    Fit(w) = Fit(w) + onePopFit;  % 适应值函数设计
end
end
%% Kmeans++ 函数
% 计算两个点之间的欧氏距离的平方
function d = dist2(x, y)
    d = sum((x - y) .^ 2);
end
 
% 计算一个点到一组点的最短距离
function d = minDist(x, C)
    d = inf; % 初始化为无穷大
    for i = 1 : size(C, 1) % 遍历每个聚类中心
        d = min(d, dist2(x, C(i, :))); % 更新最短距离
    end
end
 
% 按照kmeans++算法的规则，从数据集中选择一个聚类中心
function c = chooseCenter(X, C)
    n = size(X, 1); % 数据集的大小
    D = zeros(n, 1); % 初始化距离数组
    for i = 1 : n % 遍历每个数据点
        D(i) = minDist(X(i, :), C); % 计算最近邻距离
    end
    D = D / sum(D); % 归一化距离数组
    r = rand(); % 生成一个随机数
    s = 0; % 初始化累积概率
    for i = 1 : n % 遍历每个数据点
        s = s + D(i); % 累加概率
        if s >= r % 如果累积概率大于等于随机数
            c = X(i, :); % 选择该点作为聚类中心
            break; % 结束循环
        end
    end
end
 
% 实现kmeans++算法，返回k个聚类中心
function C = kmeanspp(X, k)
    C = zeros(k, size(X, 2)); % 初始化聚类中心矩阵
    C(1, :) = X(randi(size(X, 1)), :); % 随机选择第一个聚类中心
    for i = 2 : k % 遍历剩余的聚类中心
        C(i, :) = chooseCenter(X, C(1 : i - 1, :)); % 按照规则选择下一个聚类中心
    end
end
 
% 实现kmeans算法，返回聚类结果
function [idx, C] = mykmeans(X, k)
    n = size(X, 1); % 数据集的大小
    idx = zeros(n, 1); % 初始化聚类标签
    C = kmeanspp(X, k); % 使用kmeans++算法选择初始聚类中心
    while true % 迭代直到收敛
        old_idx = idx; % 保存旧的聚类标签
        for i = 1 : n % 遍历每个数据点
            min_d = inf; % 初始化最小距离
            for j = 1 : k % 遍历每个聚类中心
                d = dist2(X(i, :), C(j, :)); % 计算距离
                if d < min_d % 如果距离更小
                    min_d = d; % 更新最小距离
                    idx(i) = j; % 更新聚类标签
                end
            end
        end
        for j = 1 : k % 遍历每个聚类中心
            C(j, :) = mean(X(idx == j, :)); % 更新聚类中心为均值
        end
        if isequal(old_idx, idx) % 如果聚类标签没有变化
            break; % 结束循环
        end
    end
end