function y = Cost(Cluster_member,Q,K,energy,energe_Q)
%计算每个粒子的适应度
% 输入 Cluster_member:传感器簇成员节点矩阵，大小为n-dead x 2；
%      Q:粒子，大小为K x 2
%      K:簇头数，也就是size(Q,1)
%      energy:网络当前能量之和
%      energe_Q:簇头当前能量之和
rou = 0.5;
distance_all = pdist2(Q,Cluster_member);%簇头和所有节点的距离
[distance_min,index] = min(distance_all);%distance_min返回最短距离，index返回对应的簇编号
D = [distance_min' index'];
D_C = zeros(1,K);
for i = 1:K
    ind = find((D(:,2) == i));
    D_C(i) = sum(D(ind));
end
f1 = max(D_C)./K;
f2 = energy/energe_Q;
y = rou*f1 + (1-rou)*f2;
end