%% 清空环境变量
clear;clc;
close all;
%% 一、初始参数设定模块
%现场尺寸-x和y最大值（单位：米）
xm = 200;
ym = 200;

%基站的坐标
sink.x = 0.5 * xm;
sink.y = 0.5 * ym;

%场地中的节点数
n = 100;

packetLength = 4000;%数据包长度 
ctrPacketLength = 100;%控制包长度

%能量模型（所有值均以焦耳为单位）
Eo = 0.5;%初始能量
ETX = 50*0.000000001;%耗传输能耗
ERX = 50*0.000000001;%接收能耗
EDA = 5*0.000000001;%数据聚合能量

%发射放大器类型
Efs = 10*0.000000000001;%小于do
Emp = 0.0013*0.000000000001;%大于do

do = sqrt(Efs/Emp);

%整个数据传输最大轮数…………………………
rmax = 10;

chp = 0.05;

%% 二、无线传感器网络模型产生模块
figure;
%构建无线传感器网络,在区域内均匀投放100个节点,并画出图形
for i = 1:n
    V(i).xd = rand(1,1)*xm;   %  坐标X轴rand()函数随机生成
    V(i).yd = rand(1,1)*ym;   %  坐标Y轴rand()函数随机生成
    V(i).G = 0;  % 成为簇头的次数
    V(i).type = 'N';   %  普通节点 
    V(i).E = Eo;  %  节点能量
    plot(V(i).xd,V(i).yd,'o');
    hold on;
end

V(n+1).xd = sink.x;  % 基站坐标
V(n+1).yd = sink.y;
plot(V(n+1).xd,V(n+1).yd,'*');
%% 三、网络运行模块
% 死亡节点数
dead = 0; % 死亡节点数目
first_dead = 0;%第一个死亡节点
teenth_dead = 0;%10%的死亡节点
all_dead = 0;%节点都死亡
%标记
flag_first_dead = 0;
flag_teenth_dead = 0;
flag_all_dead = 0;
% 传输到基站和簇头的比特计数器
packets_TO_BS = 0;
packets_TO_CH = 0;
for r = 0:rmax %  主循环次数
    dead = 0; % 每轮死亡节点数
    energy = 0;% 每轮节点剩余总能量
    cun = 1;
    cunhuo = [];
    for Ei = 1:n   % 所有节点进行判断
        if V(Ei).E>0  % 判断存活节点是否为0
            cunhuo(cun) = Ei;
            cun = cun + 1;
            numcunhuo= length(cunhuo);
        end
    end
    if numcunhuo == 0  % 判断节点是否存活
       STATISTICS.DEAD(r+1) = n - numcunhuo;
       STATISTICS.alive(r+1) = numcunhuo;
       STATISTICS.energy(r+1) = energy;
       break;
    end
    dead = n - numcunhuo;
    % (3)第一个死亡节点的产生时间(用轮次表示)
    % 第一个节点死亡时间
    if dead == 1
       if flag_first_dead == 0
          first_dead = r;
          flag_first_dead = 1;
       end
    end
    % 10%的节点死亡时间
    if dead == 0.1*n
       if flag_teenth_dead ==0
          teenth_dead = r;
          flag_teenth_dead = 1;
       end
    end
    if dead == n
       if flag_all_dead == 0
          all_dead = r;
          flag_all_dead = 1;
        end
    end
    for sw = 1:numcunhuo
        if V(cunhuo(sw)).E > 0
           energy = energy + V(cunhuo(sw)).E;%统计每轮节点总能量和
        end
    end
    STATISTICS.DEAD(r+1) = dead;
    STATISTICS.alive(r+1) = numcunhuo;
    STATISTICS.energy(r+1) = energy;
    cluster = 0;%计数簇头数
%%  1、为优化算法生成种群
    if length(cunhuo)>20  % 判断节点是否足够形成种群
    originalArray = cunhuo;  %  n个节点按顺序组成的数组
    k = ceil(numcunhuo*chp);  % 最优簇头数(根据LEACH协议论文中） 向上取整
    num_zhongqun = 30;  % 种群个体数量规模(偶数）
    PopPos = [];   % 种群allSelections矩阵
    for gm = 1:num_zhongqun   % 从N个节点中随机选取其中K个共进行200次，生成种群规模
        selectedNumbers = originalArray(randperm(length(originalArray), k));  % 在originalArry中随机选取K个数并赋值给selectedNumbers数组
        PopPos = [PopPos;selectedNumbers];  % 将selectedNumbers数组放入种群PopPos矩阵中
    end
% disp(PopPos);% 初始矩阵 ￥￥￥￥￥￥￥
%%  2、通过优化算法在种群中找到最优的结果
    PopFit = fit(PopPos,V,num_zhongqun,k,numcunhuo,cunhuo);  % 初始化种群的调用适应度函数计算适应度
    BestF=inf;  % 将BestF（最优适应度值）初始化为无穷大（inf）
    BestX=[];  % 将BestX（最优解的位置）初始化为空数组。
    % for i=1:nPop：这是一个 for 循环，它从 1 遍历到 nPop，其中 nPop 是种群的大小，即种群中个体的数量。
    % if PopFit(i) <= BestF：这是一个 if 条件语句，它检查当前个体的适应度值 PopFit(i) 是否小于或等于当前记录的最优适应度 BestF。
    % BestF=PopFit(i);：如果当前个体的适应度值更好（即更小，因为我们通常希望最小化适应度函数），则更新 BestF 为这个新的适应度值。
    % BestX=PopPos(i,:);：同时，将当前个体的位置 PopPos(i,:) 赋值给 BestX，这样 BestX 就保存了当前最优解的位置。
    for q = 1:num_zhongqun   % 将初始化种群的结果最好的保留在BestF和BestX中
        if PopFit(q)<=BestF 
           BestF=PopFit(q);
           BestX=PopPos(q,:);
        end
    end
%%   3、遗传算法选出簇头
    numdiedai = 70; % 遗传算法迭代次数………………………………
    for Dd = 1:numdiedai  % 遗传算法迭代次数
        A = PopPos; % 1.初始种群赋值给A开始进化。 2.进化后的种群再次赋值给A进行第二次进化。
    % 1.交叉处理（个体之间进行交叉处理一定发生）
        random_permutation = randperm(num_zhongqun); % 生成1到num_zhongqun(行数)的随机序列
        % disp(random_permutation);   %   交叉的个体序列￥￥￥￥￥￥￥￥
        jcnum_o = 1; % 第一个交叉处理的个体
        JCNUM = num_zhongqun/2; % 交叉的次数
        for jcnum = 1:JCNUM  % 所有进行交叉处理
            rowA=random_permutation(jcnum_o);  % 随机找两个体进行交叉遗传
            jcnum_t = jcnum_o + 1;
            rowB=random_permutation(jcnum_t);
            jcnum_o = jcnum_t + 1;
            cj = 1;  % 判断是否到达交叉个数
            for ic =1:k      % k最优簇头数(矩阵的列数)如果个体A的第i个数与个体B的全体都不一样且个体B的第i个数与个体A的全体都不一样才会对个体A与个体B的第i个数进行互换
                if all(A(rowA,ic)~=A(rowB,:))&&all(A(rowB,ic)~=A(rowA,:))
                   temp = A(rowA,ic); % 执行交叉
                   A(rowA,ic)=A(rowB,ic);
                   A(rowB,ic)=temp;
                   cj=cj+1;  % 计算交叉元素的个数
                   if cj > floor(k/2) % floor()函数向下取整到最接近的整数，即取不大于 x 的最大整数。
                      break;   % 互换的最多为n/2个到达n/2个自动停止，否则一直遍历全部个体基因停止
                   end
                end
            end
        end 
        PopPos = A; % 结果再传给PoPos种群
       % disp(PopPos); % 交叉后的矩阵￥￥￥￥￥￥￥￥
        PopFit = fit(PopPos,V,num_zhongqun,k,numcunhuo,cunhuo);  % 更新后种群的调用适应度函数计算适应度
        for newq = 1:num_zhongqun   % 将新种群的结果与上次种群的BeatF和BestX进行对比并最好的保留在BestF和BestX中
            if PopFit(newq)<=BestF 
               BestF=PopFit(newq);
               BestX=PopPos(newq,:);
            end
        end
       
    % 2.变异(所有个体以一定概率进行变异）
        for by = 1:num_zhongqun  % 所有个体都可能发生变异
            bygl = rand(1); %  生成0到1之间的任意数进行判断该个体是否变异
            if bygl<0.4 % 小于0.2则发生变异
               random_number = rand(1); % 生成0到1之间的任意数进行判断何种变异
               if random_number<0.5  % 两个变异各占50%
    % 1)自由变异
                  wei = ceil(k*0.2); % ceil()函数向上取整到最接近的整数，即取不小于 x 的最小整数。
                  for i = 1:wei  % 进行多个位置的变异
                      rz = randi([1, k]);  % 生成1到k簇头数(矩阵的列数)之间的随机整数来表示变异的位置（有一定几率生成相同数即同一个位置发生两次变异，这个情况也可以允许）
                      h = by;  %  by个体发生变异
                      random_integer = randi([1, n]);   %生成1到n节点数之间的随机整数来表示变异后的结果（生成的只是该行中没有的元素，可以生成整个矩阵中没有的元素)
                      while true
                            if all(A(h,:) ~= random_integer)&&all(V(random_integer).E>0)   % 不等且改点存活
                               A(h,rz) = random_integer;  % 变异前后不相等这直接赋值
                            else 
                               random_integer = randi([1, n]);  % 变异前后的值相等则再次重新生成随机数
                            end
                            if all(A(h,:) ~= random_integer)&&all(V(random_integer).E>0)   % 再次判断生成的随机数
                               A(h,rz) = random_integer;   % 不相等则赋值
                               break;  % 直到不等并赋值为止
                            end
                      end
                  end 
               else
    % 2)进化变异 （优秀基因如果变异前存在，仍然以优秀基因进行变异。变异的个数是一定的）
                  B = nchoosek(BestX,4); % 从优秀个体选出4个基因组合组成的不同矩阵B  ……………………
                  num_H = size(B, 1); % 获取矩阵B的行数
                  num_L = size(B, 2); % 获取矩阵B的列数
                  PopFitF = fit(B,V,num_H,num_L,numcunhuo,cunhuo);  % 计算4个基因的适应度函数并将适应度值存在PopFitF中
                  minG = min(PopFitF); % 取PopFitF中的最小值
                  YX = find(PopFitF == minG); % 获取最小值在PopFitF中的位置
                  YXJY = B(YX,:); % 从优秀个体中获取优秀基因
                  random_permutation = randperm(k); % 生成1到k簇头数(矩阵的列数)的随机序列
                  random_integers = random_permutation(1:4);  % 选择前4个随机整数作为变异的位置  ……………………
                  for s = 1:4       % 优秀基因进化  ……………………
                      yx = by;  % by个体进行变异进化
                      if YXJY(s)~=A(yx,:)  % 当YXJY(s)与Ayx行的所有都不一样才会对Ayx行进行变异赋值处理
                         A(yx,random_integers(s)) = YXJY(s);  % 进化矩阵中某个数值
                      end
                  end
               end  
            end  % 该个体是否发生变异
        end % 所有个体都以一定概率变异
        PopPos = A; % 结果再传给PoPos种群
       % disp(A);  % 变异后的矩阵￥￥￥￥￥￥￥
        PopFit = fit(PopPos,V,num_zhongqun,k,numcunhuo,cunhuo);  % 更新后种群的调用适应度函数计算适应度
        for newq = 1:num_zhongqun   % 将新种群的结果与上次种群的BeatF和BestX进行对比并最好的保留在BestF和BestX中
            if PopFit(newq)<=BestF 
               BestF=PopFit(newq);
               BestX=PopPos(newq,:);
            end
        end  
    end % 迭代次数
    BGT=BestX;  % 获取最优个体即簇头
    chnum =  length(BGT);  % 簇头数量
    for sdd = 1:chnum  % 簇头次数加一
        V(sdd).G = V(sdd).G+1; 
    end
    %基站广播簇头，所有节点接收
    for gb = 1:numcunhuo
        V(cunhuo(gb)).E = V(cunhuo(gb)).E - ERX * ctrPacketLength;
    end
%%  4、普通节点入簇
    pt = 1;
    putong = [];  % 直接传输给基站的普通节点需要一直存储所以不能再循环中不然会变为空向量
    for i =1:numcunhuo % 存活节点选择簇头
        if V(cunhuo(i)).E>0 % 判断节点是否有能量
        if cunhuo(i) ~= BGT  % 簇头节点不进行入簇
           YCH = []; % 每次更新为空向量，来放置预选簇头
           d1= sqrt((V(cunhuo(i)).xd - sink.x)^2 + (V(cunhuo(i)).yd - sink.y)^2);  % 节点到基站的距离
           c=1; % 数组从1开始
           for s = 1:k
               d2= sqrt((V(BGT(s)).xd - sink.x)^2 + (V(BGT(s)).yd - sink.y)^2);  % 簇头到基站的距离
               d3 = sqrt((V(BGT(s)).xd - V(cunhuo(i)).xd)^2 + (V(BGT(s)).yd - V(cunhuo(i)).yd)^2);  % 节点到簇头的距离
               if d1>d2&&d1>d3     % 选择节点的预选簇头并放入YCH向量中(节点到基站要大于簇头到基站和要大于节点到簇头）
                  YCH(c) = BGT(s);
                  c=c+1;
               end
           end
           z = length(YCH);  % 获取向量YCH的列数
           if z ~= 0
              fd3 = []; % 定义空向量放置节点到所有预选簇头的距离
              CH = 0; % 假设初始时CH为0
              for rc = 1:z
                  d3 = sqrt((V(YCH(rc)).xd - V(cunhuo(i)).xd)^2 + (V(YCH(rc)).yd - V(cunhuo(i)).yd)^2);  % 节点到预先簇头的距离
                  Ech = 1/(V(YCH(rc)).E);  % 预选簇头的能量
                  q4 = 0.4;  %  节点到预选簇头的权值
                  q5 = 0.6;  %  预选簇头能量的权值
                  xch = q4*d3 + q5*Ech; % 选取簇头时的适应度函数
                  fd3(rc) = xch;  % 适应度函数值放入空向量中
                  minD = min(fd3); % 找最小适应度函数
                  CHwz = find(fd3 == minD); % 最小距离的节点在fd3中的位置
                  CH = YCH(CHwz);  % 在fd3中提取出距离最小位置的节点CH即簇头
              end
              disjc = sqrt((V(CH).xd - V(cunhuo(i)).xd)^2 + (V(CH).yd - V(cunhuo(i)).yd)^2);    % 节点到簇头的距离
              %向簇头发送加入消息、向簇头发送数据包
              if (disjc > do)
                  V(cunhuo(i)).E = V(cunhuo(i)).E - ( ETX*packetLength + Emp*packetLength*disjc^4); %向簇发送头数据包
              else
                  V(cunhuo(i)).E = V(cunhuo(i)).E - ( ETX*packetLength + Efs*packetLength*disjc^2); %向簇头发送数据包
              end
              %接收簇头确认加入控制消息
              V(cunhuo(i)).E = V(cunhuo(i)).E - ERX*ctrPacketLength;
              %簇头接收簇成员的加入消息和数据包，簇头向簇成员发送确认加入的信息
              if(disjc > 0)
                 V(CH).E = V(CH).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
              end
              %CHU = [S(i).xd,S(CH).xd];  % 获取起点和终点的横坐标
              %DAO = [S(i).yd,S(CH).yd];  % 获取起点和终点的纵坐标
              %plot(CHU,DAO,'b-');  % 画出节点入簇的线段 
           else
              putong(pt) = cunhuo(i);   % 普通节点存储到putong向量中
              pt = pt+1;
           end
        end  % 判断节点是否为簇头节点
        end % 判断节点是否有能量
    end   % 所有节点入簇
    buneng = [];
    else
        buneng = cunhuo; % 存活节点不足形成种群时直接传输
        BestX = [];
        putong = [];
    end
%%  5、数据传输  
    qishijiedian = horzcat(BestX, putong,buneng); %  向量合并为所有起始节点的合集BestX向量为簇头节点，putong向量为直接节点 
    changdu = length(qishijiedian);  %  所有起始节点的个数
    for CS = 1:changdu   % 所有起始节点开始传输
       % 初始化
        qishi = qishijiedian(CS);
        while all(V(qishi).xd ~= V(n+1).xd)&&all(V(qishi).yd ~= V(n+1).yd)   % 判断是否到达基站
       % 选取邻居节点
              YCH = []; % 每次更新为空向量，来放置满足d1>d2的节点
              d1 =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2);   % 起始节点到基站的距离
              c = 1;
              for i = 1:numcunhuo
                  if V(cunhuo(i)).E>0  % 判断节点是否有能量
                     d2 = sqrt((V(cunhuo(i)).xd - sink.x)^2 + (V(cunhuo(i)).yd - sink.y)^2);  % 所有节点到基站的距离
                     if d1>d2 % 选择节点并放入YCH向量中
                        YCH(c) = cunhuo(i);
                        c=c+1;
                     end
                  end
              end
              linjv = []; % 每次更新为空向量，来放置满足d3<d1的节点
              p = length(YCH);
              x = 1;
              if p~=0
                 for q = 1:p
                     d3 = sqrt((V(YCH(q)).xd - V(qishi).xd)^2 + (V(YCH(q)).yd - V(qishi).yd)^2);   % 起始节点到预选跳转节点的距离
                     if d3<d1 % 满足第二个条件的节点并放入linjv向量中
                        linjv(x) = YCH(q);
                        x=x+1;
                     end
                 end
              else %  判断YCH是否为空如果为空直接到基站
                 qiji =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qiji^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和基站的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和基站的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end  
          % 判断邻居节点
              m = length(linjv);
              if m~=0  % 判断linjv是否为空
                 shiyingdu = [];
                 for z = 1:m
                     q1 = 0.55;   % 权值
                     q2 = 0.3;   % 权值
                     q3 = 0.15;   % 权值
                     d4 = sqrt((V(qishi).xd - V(linjv(z)).xd)^2 + (V(qishi).yd - V(linjv(z)).yd)^2); % 起始节点到预选跳转节点的距离
                     d5 = sqrt((V(linjv(z)).xd - sink.x)^2 + (V(linjv(z)).yd - sink.y)^2);        % 预选跳转节点到簇头的距离
                     fitchuanshu = q1*(1/(V(linjv(z)).E))+q2*d4+q3*d5;
                     shiyingdu(z) = fitchuanshu;
                 end
                 minD = min(shiyingdu); % 找最小值
                 TZshiying = find(shiyingdu == minD); % 最小适应度在全部邻居节点适应度中的位置
                 TZnode = linjv(TZshiying);  % 在邻居中提取出适应度最小的即跳转节点TZnode
                 qitiao = sqrt((V(qishi).xd - V(TZnode).xd)^2 + (V(qishi).yd - V(TZnode).yd)^2); % 起始节点到跳转节点的距离
                 if (qitiao > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qitiao^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qitiao^2);
                 end
                 %CHU = [S(qishi).xd,S(TZnode).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(TZnode).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
              else  % 判断linjv是否为空如果为空直接到基站
                 qiji =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qiji^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取转发点和终点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取转发点和终点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;  % while循环停止条件
              end
              qishi = TZnode; % 起始节点开始前进
              if all(V(qishi).xd == V(n+1).xd)&&all(V(qishi).yd == V(n+1).yd) 
                 qiji =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qiji^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end
         end   % 判断是否到达基站
     end % 全部数据点
     disp(r);
end % 主循环
%% 四、绘图显示
figure;
plot(0:rmax, STATISTICS.DEAD, 'r', 'LineWidth', 2);
xlabel('轮数'); ylabel('死亡节点数');
figure;
plot(0:rmax, STATISTICS.alive, 'b', 'LineWidth', 2);
xlabel('轮数'); ylabel('活动节点数');
figure;
plot(0:rmax, STATISTICS.energy, 'k', 'LineWidth', 2);
xlabel('轮数'); ylabel('剩余能量');
%% 适应值函数
% PopPos 是一个矩阵，其中每一行代表一个个体的位置。
% Dim 是最优簇头的数量，也是适应度函数的维度。PopFit 是一个向量，用于存储每个个体的适应度值。
function Fit = fit(swq,d,num_zhongqun,k,n,cunhuo) 
nPop = num_zhongqun;   % 种群数量
Dim = k;  % 适应值函数的维度即最优簇头数
    Fit=zeros(1,nPop);   % 创建一个 1 行 nPop 列的列向量，所有元素都是 0。这个向量用于存储种群中每个个体的适应度值。
    for w = 1:nPop     % 循环提取种群PopPos矩阵中个体
        geti = swq(w, :);   % 从 PopPos 矩阵中提取第w行个体的所有数据。                                             
        for h = 1:Dim
            q1 = 0.29; % 权重
            q2 = 0.08; % 权重
            q3 = 0.19; % 权重
            q4 = 0.23; % 权重
            q5 = 0.21; % 权重
            for o = 1:Dim  % Dim为最优簇头数目
                for l = o+1:Dim
                    disNN = 0;  % 初始化距离和
                    disNNone = sqrt((d(geti(o)).xd - d(geti(l)).xd)^2 + (d(geti(o)).yd - d(geti(l)).yd)^2);  % 簇首h之间的距离
                    disNN = disNN + disNNone;  % 各个簇首之间的距离的累加和
                end
            end
            for e = 1:Dim  % Dim为最优簇头数目
                for v = 1:n  % n为场地中节点数目
                    disNC = 0;  % 初始化距离和
                    disNCone = sqrt((d(geti(e)).xd - d(cunhuo(v)).xd)^2 + (d(geti(e)).yd - d(cunhuo(v)).yd)^2);  % 簇首h与每个节点之间的距离
                    disNC = disNC + disNCone;  % 各个簇首与每个节点之间的距离的累加和
                end
            end
            onePopFit = q1*(1/(d(geti(h)).E))+q2*(d(geti(h)).G)+q3*(1/disNN)+q4*(sqrt((d(geti(h)).xd - d(n+1).xd)^2+ (d(geti(h)).yd - d(n+1).yd)^2))+q5*disNC;
            Fit(w) = Fit(w) + onePopFit;  % 适应值函数设计
        end
    end
end