%EEUC协议仿真(非均匀分簇路由协议)(2005)
%该算法没考虑控制包相关 
%% 清空环境变量
clear;clc;
close all
%% 1、初始参数设定模块
%监测区域大小（单位：米）
xm = 200;
ym = 200;

%基站的x和y坐标
sink.x = 100;
sink.y = 250;

%场地中的节点数
n = 400;

%最大循环轮数
rmax = 1200; 

%能量模型(所有值均以焦耳为单位)
E0 = 0.5;%初始能量
ETX = 5e-8;%传输能耗
ERX = 5e-8;%接收能耗
EDA = 5e-9;%数据聚合能量

%发射放大器类型
Efs = 1e-11;%小于d0
Emp = 1.3e-15;%大于d0
d0 = sqrt(Efs/Emp);%距离阈值

%数据包和控制包长度
packetLength = 4000;%数据包长度 

ce = 0.5;
T = 0.4;
Rc_max = 90;
TD_MAX = 150;
%% 2、无线传感器网络模型产生模块
%构建无线传感器网络,在区域内均匀投放所有节点,并画出图形
%加入基站信息
S1(n+1).xd = sink.x;
S1(n+1).yd = sink.y;
BS = [S1(n+1).xd,S1(n+1).yd];
dmax = 0;%传感器与基站的最大距离
dmin = 1e5;%传感器与基站的最小距离
figure;
for i = 1:n
    S1(i).xd = rand(1,1)*xm;%坐标
    S1(i).yd = rand(1,1)*ym;
    S1(i).E = E0;%初始化节点能量
    S1(i).type = 'N';%簇成员(普通节点)
    S1(i).dtoCH = 0;%节点距离簇头的距离
    S1(i).dtoBS = pdist2([S1(i).xd S1(i).yd],BS);%节点距离基站的距离
    if S1(i).dtoBS < dmin
        dmin = S1(i).dtoBS;
    end
    if S1(i).dtoBS > dmax
        dmax = S1(i).dtoBS;
    end
    plot(S1(i).xd,S1(i).yd,'o');
    hold on;
end
plot(S1(n+1).xd,S1(n+1).yd,'p','MarkerSize',15);
%计算每个节点的竞争半径
for i = 1:n
    S1(i).Rc = (1-ce*((dmax-S1(i).dtoBS)/(dmax-dmin)))*Rc_max;
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
%% 3、网络运行模块 
%死亡节点数指标
dead_first3 = 0;%第一个死亡节点
dead_ten3 = 0;%10%的死亡节点
dead_half3 = 0;%一半的死亡节点
dead_all3 = 0;%节点都死亡

%节点死亡数指标对应标记
flag_dead_first3 = 0;
flag_dead_ten3 = 0;
flag_dead_half3 = 0;
flag_dead_all3 = 0;

%主循环
for r = 0:rmax 
    dead3 = 0;%计算死亡节点数
    energy3 = 0;%每轮节点剩余总能量
    SNode = [];%存活节点集合
    Cch = [];%候选节点集合
    j = 0;
    for i = 1:n
        %检查有无死亡节点
        if S1(i).E <= 0
            dead3 = dead3+1;
            % 第一个节点死亡时间
            if dead3 == 1
                if flag_dead_first3 == 0
                    dead_first3 = r+1;
                    flag_dead_first3 = 1;
                end
            end
            % 10%的节点死亡时间
            if dead3 == 0.1*n
                if flag_dead_ten3 ==0
                    dead_ten3 = r+1;
                    flag_dead_ten3 = 1;
                end
            end
            % 50%的节点死亡时间
            if dead3 == 0.5*n
                if flag_dead_half3 ==0
                    dead_half3 = r+1;
                    flag_dead_half3 = 1;
                end
            end
            % 全部的节点死亡时间
            if dead3 == n
                if flag_dead_all3 == 0
                    dead_all3 = r+1;
                    flag_dead_all3 = 1;
                end
            end
        elseif S1(i).E > 0
            energy3 = energy3 + S1(i).E;%统计每轮节点总能量和
            S1(i).type = 'N';
            S1(i).pl = packetLength;
            j = j+1;
            SNode.d(j,:) = [S1(i).xd S1(i).yd];%存活节点集合
        end
    end
    
    STATISTICS3.dead(r+1) = dead3;%每轮死亡节点数
    STATISTICS3.alive(r+1) = n-dead3;%每轮存活节点数
    STATISTICS3.energy(r+1) = energy3;%每轮剩余总能量

    %如果只剩下一个节点了，则直接和基站通信
    if dead3 == n-1
    %直接和基站通信
        for i = 1:n
            if S1(i).E > 0
                dtoBS = S1(i).dtoBS;
                if (dtoBS < d0)
                    S1(i).E = S1(i).E- (ETX * packetLength + Efs * packetLength * dtoBS^2);
                else
                    S1(i).E = S1(i).E- (ETX * packetLength + Emp * packetLength * dtoBS^4); 
                end
                STATISTICS.COUNTCHS(r+1) = 1;
            end
        end
        continue;
    end

    %如果节点都死亡了，通过continue来跳过下面的操作
    if dead3 == n
        STATISTICS.COUNTCHS(r+1) = 0;
        continue;
    end

    % 广播构建候选簇头
    count = 0;
    for i = 1:n
        if S1(i).E > 0
            miu = rand();
            if  miu < T
                count = count + 1;
                Cch.id(count) = i;%竞选簇头ID
                Cch.E(count) = S1(i).E;%竞选簇头剩余能量
                Cch.d(count,:) = [S1(i).xd S1(i).yd];%竞选簇头坐标
            end
        end
    end

    if isempty(Cch)%如果没有簇头
        %节点直接和基站通信
        for i = 1:n
            if S1(i).E > 0
                dtoBS = S1(i).dtoBS;
                if (dtoBS < d0)
                    S1(i).E = S1(i).E- (ETX * packetLength + Efs * packetLength * dtoBS^2);
                else
                    S1(i).E = S1(i).E- (ETX * packetLength + Emp * packetLength * dtoBS^4); 
                end
                STATISTICS.COUNTCHS(r+1) = 1;
            end
        end
        continue;
    end

    %构建候选簇头的邻簇头集合
    %将候选簇头集合按能量从大到小排序
    [E_descend,index1] = sort(Cch.E,'descend');
    %更新候选簇头结构体
    Cch.id = Cch.id(index1);
    Cch.E = E_descend;
    Cch.d = Cch.d(index1,:);
    %构建一个数组，维度为count x 3,第1,2列放坐标3列放参选或退出记号
    SCH = [Cch.d ones(count,1)];%维度count x 3
    distance_SCH = pdist2(Cch.d,Cch.d);%所有候选节点之间的距离，维度count x count
    distance_SCH(logical(eye(size(distance_SCH)))) = inf;
    %竞选簇头
    elected = [];
    for i = 1:count
        if SCH(i,3) == 1%候选簇头未退出竞争
            ID = Cch.id(i);
            id_under_Rc = find(distance_SCH(i,:) <= S1(ID).Rc);
            intersection = intersect(elected,id_under_Rc);%已经当选的簇头和要退出的簇头的交集
            if isempty(intersection)
                SCH(id_under_Rc,3) = 0;
                elected = [elected i];
            else
                SCH(i,3) = 0;
            end
        end
    end
    
    index2 = find(SCH(:,3) == 1);%簇头在SCH数组中对应的编号
    CH = Cch.d(index2,:);%簇头坐标集合
    
    %% 4.2成簇，簇内通信
    %确定簇头
    K = size(index2,1);
    for i =1:K
        CH_id = Cch.id(index2(i));
        S1(CH_id).type = 'C';
    end
    isB = ismember(SNode.d,CH);%簇头节点的位置逻辑值为1，非簇头节点的位置逻辑值为0
    Cnode = reshape(SNode.d(~isB),[],2);%传感器非簇头节点矩阵
    distance_all = pdist2(Cnode,CH);%非簇头和簇头节点的距离,维度MxK
    [dtoCH,index3] = min(distance_all,[],2);
    m = 0;
    %给簇成员标记簇号,记录到簇头的距离以及对应簇头的编号
    for i = 1:n 
        if ( S1(i).type =='N' && S1(i).E>0 )%普通节点
            m = m+1;
            S1(i).of = index3(m);
            S1(i).dtoCH = dtoCH(m);
            S1(i).CHid = Cch.id(index2(S1(i).of));
        end
    end    
    %簇内通信    
    for i = 1:n
        if ( S1(i).type=='N' && S1(i).E>0 )%普通节点
            dtoCH = S1(i).dtoCH;%与簇头的距离
            CH_id = S1(i).CHid;%簇头编号
            if dtoCH < d0
                S1(i).E = S1(i).E - (ETX*packetLength + Efs*packetLength*dtoCH^2);%向簇头发送数据包
            else
                S1(i).E = S1(i).E - (ETX*packetLength + Emp*packetLength*dtoCH^4);
            end
            S1(CH_id).E = S1(CH_id).E - (ERX + EDA)*packetLength;%接收并融合簇成员发来的数据包
        end
    end
%% 4.3簇间通信
    C_of_CH = [];%簇头节点结构体
    C_of_CH.d = CH;%簇的坐标集合
    C_of_CH.id = Cch.id(index2);%簇的id集合
    for i = 1:K
        C_of_CH.dtoBS(i) =  S1(C_of_CH.id(i)).dtoBS;%簇头距离基站距离集合
    end
    for i = 1:K
        CH_id = C_of_CH.id(i);
        dtoBS = S1(CH_id).dtoBS;
        if dtoBS < TD_MAX
            if dtoBS < d0
                S1(CH_id).E = S1(CH_id).E - ( ETX*S1(CH_id).pl + Efs*S1(CH_id).pl*dtoBS^2);
            else
                S1(CH_id).E = S1(CH_id).E - ( ETX*S1(CH_id).pl + Emp*S1(CH_id).pl*dtoBS^4);
            end
            S1(CH_id).pl = 0;
        else
            dt = CH_id;
            while dtoBS >= TD_MAX
                A = [S1(dt).xd S1(dt).yd];
                Ere = [S1(C_of_CH.id).E];%每个簇头的剩余能量
                [index4,sign] = CostEEUC(dtoBS,A,C_of_CH.d,C_of_CH.dtoBS,Ere);
                if sign == 0%没有节能的中继节点，则直接和基站通信
                    S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Emp*S1(dt).pl*dtoBS^4);%向基站发送数据包
                    S1(dt).pl = 0;
                    dtoBS = 0;
                else %即有节能的中继节点，则与中继节点通信
                    CN_id = C_of_CH.id(index4);%中继节点id
                    dtoCN = pdist2(A,C_of_CH.d(index4,:));%与中继节点的距离
                    if (dtoCN < d0)
                        S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Efs*S1(dt).pl*dtoCN^2);%向中继节点发送数据包
                    else
                        S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Emp*S1(dt).pl*dtoCN^4);
                    end
                    %中继节点接收传输节点的数据包
                    if(dtoCN > 0)
                        S1(CN_id).E = S1(CN_id).E - ERX*S1(dt).pl;%接受传输节点发来的数据包,不融合数据
                        S1(CN_id).pl = S1(CN_id).pl + S1(dt).pl;
                    end
                    S1(dt).pl = 0;
                    dtoBS = S1(CN_id).dtoBS;
                    dt = CN_id;
                end
            end
            if dtoBS>0 && dtoBS<TD_MAX%最后的中继节点将数据传输给基站
                %向基站发送数据包
                if (dtoBS < d0)
                    S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Efs*S1(dt).pl*dtoBS^2);
                else
                    S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Emp*S1(dt).pl*dtoBS^4);
                end
                S1(dt).pl = 0;
            end
        end
    end
end
%% 绘图显示
figure; 
plot(0:rmax, STATISTICS3.alive, 'r', 'LineWidth', 2);
xlabel('轮数'); ylabel('活动节点数');
figure;
plot(0:rmax, STATISTICS3.energy, 'b', 'LineWidth', 2);
xlabel('轮数'); ylabel('剩余能量');
