%% 清空环境变量
clear;clc;
close all;

%% 1、初始参数设定模块
%监测区域大小（单位：米）
xm = 200;
ym = 200;

%基站的x和y坐标
sink.x = 0.5 * xm;
sink.y = 0.5 * ym;

%场地中的节点数
n = 100;

%簇头概率
chp=0.05;

%最大循环轮数
rmax = 1000;

%能量模型(所有值均以焦耳为单位)
Eo = 0.2;%初始能量
ETX = 50*0.000000001;%传输能耗
ERX = 50*0.000000001;%接收能耗
EDA = 5*0.000000001;%数据聚合能量

%发射放大器类型
Efs = 10*0.000000000001;%小于do
Emp = 0.0013*0.000000000001;%大于do
do = sqrt(Efs/Emp);%距离阈值

%数据包和控制包长度
packetLength = 2000;%数据包长度 
ctrPacketLength = 50;%控制包长度

% eeuc数据变量
S1(n+1).xd = sink.x;
S1(n+1).yd = sink.y;
BS = [S1(n+1).xd,S1(n+1).yd];
dmax = 0;%传感器与基站的最大距离
dmin = 1e5;%传感器与基站的最小距离
%% 2、无线传感器网络模型产生模块
%构建无线传感器网络,在区域内均匀投放所有节点,并画出图形
figure;
for i = 1:n
    S(i).xd = rand(1,1)*xm;%坐标
    S(i).yd = rand(1,1)*ym;
    S(i).E = Eo;%初始化节点能量
    S(i).G = 0; %簇头的次数
    S(i).type = 'N';%簇成员(普通节点) 
    plot(S(i).xd,S(i).yd,'o');
    hold on;
    N(i).xd = S(i).xd;%坐标
    N(i).yd = S(i).yd;
    N(i).G = 0;%"G = 0"表示节点本周期内未当选过簇头，当选则改为"G = 1"
    N(i).E = Eo;%初始化节点能量
    %最初没有簇头只有簇成员
    N(i).type = 'N';%簇成员(普通节点) 
    V(i).xd = S(i).xd;   %  坐标X轴rand()函数随机生成
    V(i).yd = S(i).yd;   %  坐标Y轴rand()函数随机生成
    V(i).G = 0;  % 成为簇头的次数
    V(i).type = 'N';   %  普通节点 
    V(i).E = Eo;  %  节点能量
    
    S1(i).xd = S(i).xd;%坐标
    S1(i).yd = S(i).yd;
    S1(i).E = Eo;%初始化节点能量
    S1(i).type = 'N';%簇成员(普通节点)
    S1(i).dtoCH = 0;%节点距离簇头的距离
    S1(i).dtoBS = pdist2([S1(i).xd S1(i).yd],BS);%节点距离基站的距离
    if S1(i).dtoBS < dmin
        dmin = S1(i).dtoBS;
    end
    if S1(i).dtoBS > dmax
        dmax = S1(i).dtoBS;
    end
end
%加入基站信息
S(n+1).xd = sink.x;
S(n+1).yd = sink.y;
N(n+1).xd = sink.x;
N(n+1).yd = sink.y;
V(n+1).xd = sink.x;
V(n+1).yd = sink.y;
plot(S(n+1).xd,S(n+1).yd,'p');
%% 3、PSO参数
MaxIter = 50;      % 最大迭代次数
nPop = 30;        % 种群规模
wmax = 0.9;
wmin = 0.4;
w = 1;
c1 = 2.0;         % 个人学习系数
c2 = 2.0;         % 全局学习系数
plimit = [0, 200];                % 位置参数限制
vlimit = [-20, 20];               % 速度限制

%数据初始化
particle.Position = cell(1,nPop);
particle.Cost = zeros(1,nPop);
particle.Velocity = cell(1,nPop);
particle.Best.Position = cell(1,nPop);
particle.Best.Cost = ones(1,nPop)*inf;
GlobalBestCost = inf;
GlobalBestPosition = [];

%% 三、网络运行模块(me)
% 死亡节点数
first_dead2 = 0;%第一个死亡节点
teenth_dead2 = 0;%10%的死亡节点
all_dead2 = 0;%节点都死亡
%标记
flag_first_dead2 = 0;
flag_teenth_dead2 = 0;
flag_all_dead2 = 0;
% 传输到基站和簇头的比特计数器
packets_TO_BS2 = 0;
packets_TO_CH2 = 0;
for r = 0:rmax %  主循环次数
    dead2 = 0; % 每轮死亡节点数
    energy2 = 0;% 每轮节点剩余总能量
    cun = 1;
    cunhuo = [];
    for Ei = 1:n   % 所有节点进行判断
        if V(Ei).E>0  % 判断存活节点是否为0
            cunhuo(cun) = Ei;
            cun = cun + 1;
            numcunhuo= length(cunhuo);
        end
    end
    if numcunhuo == 0  % 判断节点是否存活
       STATISTICS2.DEAD(r+1) = n - numcunhuo;
       STATISTICS2.alive(r+1) = numcunhuo;
       STATISTICS2.energy(r+1) = energy2;
       break;
    end
    dead2 = n - numcunhuo;
    % (3)第一个死亡节点的产生时间(用轮次表示)
    % 第一个节点死亡时间
    if dead2 == 1
       if flag_first_dead2 == 0
          first_dead2 = r;
          flag_first_dead2 = 1;
       end
    end
    % 10%的节点死亡时间
    if dead2 == 0.1*n
       if flag_teenth_dead2 ==0
          teenth_dead2 = r;
          flag_teenth_dead2 = 1;
       end
    end
    if dead2 == n
       if flag_all_dead2 == 0
          all_dead2 = r;
          flag_all_dead2 = 1;
        end
    end
    for sw = 1:numcunhuo
        if V(cunhuo(sw)).E > 0
           energy2 = energy2 + V(cunhuo(sw)).E;%统计每轮节点总能量和
        end
    end
    STATISTICS2.DEAD(r+1) = dead2;
    STATISTICS2.alive(r+1) = numcunhuo;
    STATISTICS2.energy(r+1) = energy2;
    cluster = 0;%计数簇头数
%%  1、为优化算法生成种群
    if length(cunhuo)>20  % 判断节点是否足够形成种群
    originalArray = cunhuo;  %  n个节点按顺序组成的数组
    k = ceil(numcunhuo*chp);  % 最优簇头数(根据LEACH协议论文中） 向上取整
    num_zhongqun = 30;  % 种群个体数量规模(偶数）
    PopPos = [];   % 种群allSelections矩阵
    for gm = 1:num_zhongqun   % 从N个节点中随机选取其中K个共进行200次，生成种群规模
        selectedNumbers = originalArray(randperm(length(originalArray), k));  % 在originalArry中随机选取K个数并赋值给selectedNumbers数组
        PopPos = [PopPos;selectedNumbers];  % 将selectedNumbers数组放入种群PopPos矩阵中
    end
% disp(PopPos);% 初始矩阵 ￥￥￥￥￥￥￥
%%  2、通过优化算法在种群中找到最优的结果
    PopFit = fit(PopPos,V,num_zhongqun,k,numcunhuo,cunhuo);  % 初始化种群的调用适应度函数计算适应度
    BestF=inf;  % 将BestF（最优适应度值）初始化为无穷大（inf）
    BestX=[];  % 将BestX（最优解的位置）初始化为空数组。
    % for i=1:nPop：这是一个 for 循环，它从 1 遍历到 nPop，其中 nPop 是种群的大小，即种群中个体的数量。
    % if PopFit(i) <= BestF：这是一个 if 条件语句，它检查当前个体的适应度值 PopFit(i) 是否小于或等于当前记录的最优适应度 BestF。
    % BestF=PopFit(i);：如果当前个体的适应度值更好（即更小，因为我们通常希望最小化适应度函数），则更新 BestF 为这个新的适应度值。
    % BestX=PopPos(i,:);：同时，将当前个体的位置 PopPos(i,:) 赋值给 BestX，这样 BestX 就保存了当前最优解的位置。
    for q = 1:num_zhongqun   % 将初始化种群的结果最好的保留在BestF和BestX中
        if PopFit(q)<=BestF 
           BestF=PopFit(q);
           BestX=PopPos(q,:);
        end
    end
%%   3、遗传算法选出簇头
    numdiedai = 100; % 遗传算法迭代次数………………………………
    for Dd = 1:numdiedai  % 遗传算法迭代次数
        A = PopPos; % 1.初始种群赋值给A开始进化。 2.进化后的种群再次赋值给A进行第二次进化。
    % 1.交叉处理（个体之间进行交叉处理一定发生）
        random_permutation = randperm(num_zhongqun); % 生成1到num_zhongqun(行数)的随机序列
        % disp(random_permutation);   %   交叉的个体序列￥￥￥￥￥￥￥￥
        jcnum_o = 1; % 第一个交叉处理的个体
        JCNUM = num_zhongqun/2; % 交叉的次数
        for jcnum = 1:JCNUM  % 所有进行交叉处理
            rowA=random_permutation(jcnum_o);  % 随机找两个体进行交叉遗传
            jcnum_t = jcnum_o + 1;
            rowB=random_permutation(jcnum_t);
            jcnum_o = jcnum_t + 1;
            cj = 1;  % 判断是否到达交叉个数
            for ic =1:k      % k最优簇头数(矩阵的列数)如果个体A的第i个数与个体B的全体都不一样且个体B的第i个数与个体A的全体都不一样才会对个体A与个体B的第i个数进行互换
                if all(A(rowA,ic)~=A(rowB,:))&&all(A(rowB,ic)~=A(rowA,:))
                   temp = A(rowA,ic); % 执行交叉
                   A(rowA,ic)=A(rowB,ic);
                   A(rowB,ic)=temp;
                   cj=cj+1;  % 计算交叉元素的个数
                   if cj > floor(k/2) % floor()函数向下取整到最接近的整数，即取不大于 x 的最大整数。
                      break;   % 互换的最多为n/2个到达n/2个自动停止，否则一直遍历全部个体基因停止
                   end
                end
            end
        end 
        PopPos = A; % 结果再传给PoPos种群
       % disp(PopPos); % 交叉后的矩阵￥￥￥￥￥￥￥￥
        PopFit = fit(PopPos,V,num_zhongqun,k,numcunhuo,cunhuo);  % 更新后种群的调用适应度函数计算适应度
        for newq = 1:num_zhongqun   % 将新种群的结果与上次种群的BeatF和BestX进行对比并最好的保留在BestF和BestX中
            if PopFit(newq)<=BestF 
               BestF=PopFit(newq);
               BestX=PopPos(newq,:);
            end
        end
       
    % 2.变异(所有个体以一定概率进行变异）
        for by = 1:num_zhongqun  % 所有个体都可能发生变异
            bygl = rand(1); %  生成0到1之间的任意数进行判断该个体是否变异
            if bygl<0.4 % 小于0.2则发生变异
               random_number = rand(1); % 生成0到1之间的任意数进行判断何种变异
               if random_number<0.5  % 两个变异各占50%
    % 1)自由变异
                  wei = ceil(k*0.2); % ceil()函数向上取整到最接近的整数，即取不小于 x 的最小整数。
                  for i = 1:wei  % 进行多个位置的变异
                      rz = randi([1, k]);  % 生成1到k簇头数(矩阵的列数)之间的随机整数来表示变异的位置（有一定几率生成相同数即同一个位置发生两次变异，这个情况也可以允许）
                      h = by;  %  by个体发生变异
                      random_integer = randi([1, n]);   %生成1到n节点数之间的随机整数来表示变异后的结果（生成的只是该行中没有的元素，可以生成整个矩阵中没有的元素)
                      while true
                            if all(A(h,:) ~= random_integer)&&all(V(random_integer).E>0)   % 不等且改点存活
                               A(h,rz) = random_integer;  % 变异前后不相等这直接赋值
                            else 
                               random_integer = randi([1, n]);  % 变异前后的值相等则再次重新生成随机数
                            end
                            if all(A(h,:) ~= random_integer)&&all(V(random_integer).E>0)   % 再次判断生成的随机数
                               A(h,rz) = random_integer;   % 不相等则赋值
                               break;  % 直到不等并赋值为止
                            end
                      end
                  end 
               else
    % 2)进化变异 （优秀基因如果变异前存在，仍然以优秀基因进行变异。变异的个数是一定的）
                  B = nchoosek(BestX,4); % 从优秀个体选出4个基因组合组成的不同矩阵B  ……………………
                  num_H = size(B, 1); % 获取矩阵B的行数
                  num_L = size(B, 2); % 获取矩阵B的列数
                  PopFitF = fit(B,V,num_H,num_L,numcunhuo,cunhuo);  % 计算4个基因的适应度函数并将适应度值存在PopFitF中
                  minG = min(PopFitF); % 取PopFitF中的最小值
                  YX = find(PopFitF == minG); % 获取最小值在PopFitF中的位置
                  YXJY = B(YX,:); % 从优秀个体中获取优秀基因
                  random_permutation = randperm(k); % 生成1到k簇头数(矩阵的列数)的随机序列
                  random_integers = random_permutation(1:4);  % 选择前4个随机整数作为变异的位置  ……………………
                  for s = 1:4       % 优秀基因进化  ……………………
                      yx = by;  % by个体进行变异进化
                      if YXJY(s)~=A(yx,:)  % 当YXJY(s)与Ayx行的所有都不一样才会对Ayx行进行变异赋值处理
                         A(yx,random_integers(s)) = YXJY(s);  % 进化矩阵中某个数值
                      end
                  end
               end  
            end  % 该个体是否发生变异
        end % 所有个体都以一定概率变异
        PopPos = A; % 结果再传给PoPos种群
       % disp(A);  % 变异后的矩阵￥￥￥￥￥￥￥
        PopFit = fit(PopPos,V,num_zhongqun,k,numcunhuo,cunhuo);  % 更新后种群的调用适应度函数计算适应度
        for newq = 1:num_zhongqun   % 将新种群的结果与上次种群的BeatF和BestX进行对比并最好的保留在BestF和BestX中
            if PopFit(newq)<=BestF 
               BestF=PopFit(newq);
               BestX=PopPos(newq,:);
            end
        end  
    end % 迭代次数
    BGT=BestX;  % 获取最优个体即簇头
    chnum =  length(BGT);  % 簇头数量
    for sdd = 1:chnum  % 簇头次数加一
        V(sdd).G = V(sdd).G+1; 
    end
    %基站广播簇头，所有节点接收
    for gb = 1:numcunhuo
        V(cunhuo(gb)).E = V(cunhuo(gb)).E - ERX * ctrPacketLength;
    end
%%  4、普通节点入簇
    pt = 1;
    putong = [];  % 直接传输给基站的普通节点需要一直存储所以不能再循环中不然会变为空向量
    for i =1:numcunhuo % 存活节点选择簇头
        if V(cunhuo(i)).E>0 % 判断节点是否有能量
        if cunhuo(i) ~= BGT  % 簇头节点不进行入簇
           YCH = []; % 每次更新为空向量，来放置预选簇头
           d1= sqrt((V(cunhuo(i)).xd - sink.x)^2 + (V(cunhuo(i)).yd - sink.y)^2);  % 节点到基站的距离
           c=1; % 数组从1开始
           for s = 1:k
               d2= sqrt((V(BGT(s)).xd - sink.x)^2 + (V(BGT(s)).yd - sink.y)^2);  % 簇头到基站的距离
               d3 = sqrt((V(BGT(s)).xd - V(cunhuo(i)).xd)^2 + (V(BGT(s)).yd - V(cunhuo(i)).yd)^2);  % 节点到簇头的距离
               if d1>d2&&d1>d3     % 选择节点的预选簇头并放入YCH向量中(节点到基站要大于簇头到基站和要大于节点到簇头）
                  YCH(c) = BGT(s);
                  c=c+1;
               end
           end
           z = length(YCH);  % 获取向量YCH的列数
           if z ~= 0
              fd3 = []; % 定义空向量放置节点到所有预选簇头的距离
              CH = 0; % 假设初始时CH为0
              for rc = 1:z
                  d3 = sqrt((V(YCH(rc)).xd - V(cunhuo(i)).xd)^2 + (V(YCH(rc)).yd - V(cunhuo(i)).yd)^2);  % 节点到预先簇头的距离
                  Ech = 1/(V(YCH(rc)).E);  % 预选簇头的能量
                  q4 = 0.4;  %  节点到预选簇头的权值
                  q5 = 0.6;  %  预选簇头能量的权值
                  xch = q4*d3 + q5*Ech; % 选取簇头时的适应度函数
                  fd3(rc) = xch;  % 适应度函数值放入空向量中
                  minD = min(fd3); % 找最小适应度函数
                  CHwz = find(fd3 == minD); % 最小距离的节点在fd3中的位置
                  CH = YCH(CHwz);  % 在fd3中提取出距离最小位置的节点CH即簇头
              end
              disjc = sqrt((V(CH).xd - V(cunhuo(i)).xd)^2 + (V(CH).yd - V(cunhuo(i)).yd)^2);    % 节点到簇头的距离
              %向簇头发送加入消息、向簇头发送数据包
              if (disjc > do)
                  V(cunhuo(i)).E = V(cunhuo(i)).E - ( ETX*packetLength + Emp*packetLength*disjc^4); %向簇发送头数据包
              else
                  V(cunhuo(i)).E = V(cunhuo(i)).E - ( ETX*packetLength + Efs*packetLength*disjc^2); %向簇头发送数据包
              end
              %接收簇头确认加入控制消息
              V(cunhuo(i)).E = V(cunhuo(i)).E - ERX*ctrPacketLength;
              %簇头接收簇成员的加入消息和数据包，簇头向簇成员发送确认加入的信息
              if(disjc > 0)
                 V(CH).E = V(CH).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
              end
              %CHU = [S(i).xd,S(CH).xd];  % 获取起点和终点的横坐标
              %DAO = [S(i).yd,S(CH).yd];  % 获取起点和终点的纵坐标
              %plot(CHU,DAO,'b-');  % 画出节点入簇的线段 
           else
              putong(pt) = cunhuo(i);   % 普通节点存储到putong向量中
              pt = pt+1;
           end
        end  % 判断节点是否为簇头节点
        end % 判断节点是否有能量
    end   % 所有节点入簇
    buneng = [];
    else
        buneng = cunhuo; % 存活节点不足形成种群时直接传输
        BestX = [];
        putong = [];
    end
%%  5、数据传输  
    qishijiedian = horzcat(BestX, putong,buneng); %  向量合并为所有起始节点的合集BestX向量为簇头节点，putong向量为直接节点 
    changdu = length(qishijiedian);  %  所有起始节点的个数
    for CS = 1:changdu   % 所有起始节点开始传输
       % 初始化
        qishi = qishijiedian(CS);
        while all(V(qishi).xd ~= V(n+1).xd)&&all(V(qishi).yd ~= V(n+1).yd)   % 判断是否到达基站
       % 选取邻居节点
              YCH = []; % 每次更新为空向量，来放置满足d1>d2的节点
              d1 =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2);   % 起始节点到基站的距离
              c = 1;
              for i = 1:numcunhuo
                  if V(cunhuo(i)).E>0  % 判断节点是否有能量
                     d2 = sqrt((V(cunhuo(i)).xd - sink.x)^2 + (V(cunhuo(i)).yd - sink.y)^2);  % 所有节点到基站的距离
                     if d1>d2 % 选择节点并放入YCH向量中
                        YCH(c) = cunhuo(i);
                        c=c+1;
                     end
                  end
              end
              linjv = []; % 每次更新为空向量，来放置满足d3<d1的节点
              p = length(YCH);
              x = 1;
              if p~=0
                 for q = 1:p
                     d3 = sqrt((V(YCH(q)).xd - V(qishi).xd)^2 + (V(YCH(q)).yd - V(qishi).yd)^2);   % 起始节点到预选跳转节点的距离
                     if d3<d1 % 满足第二个条件的节点并放入linjv向量中
                        linjv(x) = YCH(q);
                        x=x+1;
                     end
                 end
              else %  判断YCH是否为空如果为空直接到基站
                 qiji =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qiji^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和基站的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和基站的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end  
          % 判断邻居节点
              m = length(linjv);
              if m~=0  % 判断linjv是否为空
                 shiyingdu = [];
                 for z = 1:m
                     q1 = 0.55;   % 权值
                     q2 = 0.3;   % 权值
                     q3 = 0.15;   % 权值
                     d4 = sqrt((V(qishi).xd - V(linjv(z)).xd)^2 + (V(qishi).yd - V(linjv(z)).yd)^2); % 起始节点到预选跳转节点的距离
                     d5 = sqrt((V(linjv(z)).xd - sink.x)^2 + (V(linjv(z)).yd - sink.y)^2);        % 预选跳转节点到簇头的距离
                     fitchuanshu = q1*(1/(V(linjv(z)).E))+q2*d4+q3*d5;
                     shiyingdu(z) = fitchuanshu;
                 end
                 minD = min(shiyingdu); % 找最小值
                 TZshiying = find(shiyingdu == minD); % 最小适应度在全部邻居节点适应度中的位置
                 TZnode = linjv(TZshiying);  % 在邻居中提取出适应度最小的即跳转节点TZnode
                 qitiao = sqrt((V(qishi).xd - V(TZnode).xd)^2 + (V(qishi).yd - V(TZnode).yd)^2); % 起始节点到跳转节点的距离
                 if (qitiao > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qitiao^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qitiao^2);
                 end
                 %CHU = [S(qishi).xd,S(TZnode).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(TZnode).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
              else  % 判断linjv是否为空如果为空直接到基站
                 qiji =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qiji^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取转发点和终点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取转发点和终点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;  % while循环停止条件
              end
              qishi = TZnode; % 起始节点开始前进
              if all(V(qishi).xd == V(n+1).xd)&&all(V(qishi).yd == V(n+1).yd) 
                 qiji =  sqrt((V(qishi).xd - sink.x)^2 + (V(qishi).yd - sink.y)^2); % 起始节点直接到基站
                 if (qiji > do)
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Emp * ctrPacketLength*qiji^4);
                 else
                    V(qishi).E = V(qishi).E - ( ETX*ctrPacketLength + Efs * ctrPacketLength*qiji^2);
                 end
                 %CHU = [S(qishi).xd,S(n+1).xd];  % 获取起点和转发点的横坐标
                 %DAO = [S(qishi).yd,S(n+1).yd];  % 获取起点和转发点的纵坐标
                 %plot(CHU,DAO,'r-');  % 画出节点传输的线段
                 break;   % while循环停止条件
              end
         end   % 判断是否到达基站
     end % 全部数据点
     disp(r);
end % 主循环
%% 4、网络运行模块 (pso)
% 死亡节点数指标
first_dead = 0;%第一个死亡节点
teenth_dead = 0;%10%的死亡节点
all_dead = 0;%节点都死亡

%节点死亡数指标对应标记
flag_first_dead = 0;
flag_teenth_dead = 0;
flag_all_dead = 0;

%传输到基站和簇头的比特计数器
packets_TO_BS = 0;
packets_TO_CH = 0;
%主循环
for r = 0:rmax 
    dead = 0;%计算死亡节点数
    energy = 0;%每轮节点剩余总能量
    Node = [];%存活节点集合
    C = [];%候选节点集合
    j = 0;
    for i = 1:n
        %检查有无死亡节点
        if S(i).E <= 0
            dead = dead+1;
            %第一个节点死亡时间
            if dead == 1
                if flag_first_dead == 0
                    first_dead = r+1;
                    flag_first_dead = 1;
                end
            end
            % 10%的节点死亡时间
            if dead == 0.1*n
                if flag_teenth_dead ==0
                    teenth_dead = r+1;
                    flag_teenth_dead = 1;
                end
            end
            if dead == n
                if flag_all_dead == 0
                    all_dead = r+1;
                    flag_all_dead = 1;
                end
            end
        end
        if S(i).E > 0
            energy = energy + S(i).E;%统计每轮节点总能量和
            S(i).type = 'N';
            j = j+1;
            Node(j,:) = [S(i).xd S(i).yd];%存活节点集合
        end
    end
    
    STATISTICS.DEAD(r+1) = dead;%每轮死亡节点数
    STATISTICS.alive(r+1) = n-dead;%每轮存活节点数
    STATISTICS.energy(r+1) = energy;%每轮剩余总能量
    
    if n-dead == 0
        STATISTICS.COUNTCHS(r+1) = 0;
        continue;
    end
    
%% 4.1、应用PSO选簇头
    %候选簇头集合
    j = 0;
    for i = 1:n
        if r ==0 %因为matlab最大精度16位，后面数据不准，第一轮会出现这种情况，所以这样编程
            j = j+1;
            C.d(j,:) = [S(i).xd S(i).yd];%候选簇头坐标
            C.E(j) = S(i).E;%候选簇头剩余能量
            C.id(j) = i;%候选簇头对应的节点编号
        else
            if S(i).E >= energy/(n-dead) %节点能量大于或等于总的平均能量
                j = j+1;
                C.d(j,:) = [S(i).xd S(i).yd];%候选簇头坐标
                C.E(j) = S(i).E;%候选簇头剩余能量
                C.id(j) = i;%候选簇头对应的节点编号
            end
        end
    end
    
    M = size(C.d,1);%候选簇头数
    K = ceil((n-dead)*chp);% 簇头数
    %初始化种群位置和速度
    for i = 1:nPop
        % 初始化位置
        C_k = randperm(M,K);
        particle.Position{i} = C.d(C_k,:);
    
        % 初始化速度
        v = zeros(K,2);
        particle.Velocity{i}=v;
    
        % 适应度
        energe_Q = sum(C.E((C_k)));
        isB = ismember(Node,particle.Position{i});
        Cluster_member = reshape(Node(~isB),[],2);%传感器簇成员节点矩阵
        particle.Cost(i)=Cost(Cluster_member,particle.Position{i},K,energy,energe_Q);
    end
    
    Iter = 1;%计数
    while Iter <= MaxIter
        %更新粒子个体最佳适应度、位置   
        for i = 1:nPop      
           if particle.Cost(i) < particle.Best.Cost(i) 
               particle.Best.Cost(i) = particle.Cost(i);%更新个体历史最佳适应度
               particle.Best.Position{i} = particle.Position{i};%更新个体历史最佳位置
           end 
        end

        %更新群体最佳适应度、位置
        if min(particle.Best.Cost) < GlobalBestCost  
            [GlobalBestCost, index1] = min(particle.Best.Cost);%更新群体历史最佳适应度
            GlobalBestPosition = particle.Best.Position{index1};%更新群体历史最佳位置
        end

        % 速度更新
        for i = 1:nPop 
            particle.Velocity{i} = particle.Velocity{i}.*w + c1*rand*(particle.Best.Position{i}-particle.Position{i}) ...
                + c2*rand*(GlobalBestPosition-particle.Position{i});% 速度更新
        end

        % 边界速度处理
        for i = 1:nPop 
            particle.Velocity{i}(particle.Velocity{i}>20) = 20;
            particle.Velocity{i}(particle.Velocity{i}<-20) = -20;
        end

        % 位置更新
        for i = 1:nPop 
            particle.Position{i} = particle.Position{i} + particle.Velocity{i};
        end

        % 边界位置处理
        for i = 1:nPop
            particle.Position{i}(particle.Position{i}>200)=200;
            particle.Position{i}(particle.Position{i}<0)=0;
        end

        %根据距离最近候选簇头位置调整粒子位置,计算相应适应度
        for i = 1:nPop 
            distance = pdist2(C.d,particle.Position{i});
            [~, index2] = min(distance);
            particle.Position{i} = C.d(index2,:);

            % 适应度
            energe_Q = sum(C.E((index2)));
            isB = ismember(Node,particle.Position{i});
            Cluster_member = reshape(Node(~isB),[],2);%传感器簇成员节点矩阵
            particle.Cost(i)=Cost(Cluster_member,particle.Position{i},K,energy,energe_Q);
        end
        Iter = Iter+1;
    end

    %根据距离最近候选簇头位置得到簇头信息
    distance = pdist2(C.d,GlobalBestPosition);
    [~, index2] = min(distance);
    
    %如果簇头重复，需要调整(这一步处理的不够好)
    length_index2 = length(unique(index2));
    cha = K-length_index2;%重复个数
    while cha ~= 0
        for i = 1:K-1
            for j = i+1:K
                if index2(i) == index2(j)
                    distance_cut = distance(:,j);%取distance的第j列
                    [~,Number] = sort(distance_cut);
                    Num = 1;
                    while length(unique(index2))~=K-(cha-1)  && Num<size(distance_cut,1)
                        Num = Num+1;
                        index2(j) = Number(Num);
                    end
                    cha = cha-1;
                end
            end
        end
    end
                  
    for i = 1:K
        %簇头接受基站的广播分簇信息
        S(C.id(index2(i))).E =  S(C.id(index2(i))).E - ERX * ctrPacketLength;
    end

    %重置群体和个体最佳适应度、位置
    GlobalBestCost = inf;
    GlobalBestPosition = [];
    particle.Best.Cost = ones(1,nPop)*inf;
    particle.Best.Position = cell(1,nPop);

%% 4.2选总簇头
    %确定簇头
    for i = 1:K
        j = C.id(index2(i));
        S(j).type = 'C';
    end

    Each_cluster = zeros(K,2);%第一列放每个簇的能量最大的节点的能量信息，第二列放节点标号,行对应簇号

    %预成簇
    for i = 1:n
        if ( S(i).type=='N' && S(i).E>0 ) %普通节点
            %加入最近的簇头
            distance_to_cluster = pdist2(C.d(index2,:),[S(i).xd S(i).yd]);
            [min_dis, dis_index] = min(distance_to_cluster);%min_dis返回最短距离，dis_index返回最短距离对应的簇号
            if S(i).E > Each_cluster(dis_index,1)
                Each_cluster(dis_index,1) = S(i).E;
                Each_cluster(dis_index,2) = i;
            end 
        end
    end

    %若有空簇，将其候选总簇头节点假定为1(这一步处理的不够好)
    for i = 1:K
        if Each_cluster(i,2) == 0
            Each_cluster(i,2) = 1;
        end
    end

    %每个候选总簇头至所有簇头距离和
    sum_distance_HCH_to_CH = sum(pdist2(C.d(index2,:),reshape([S(Each_cluster(:,2)).xd S(Each_cluster(:,2)).yd],[],2)));
    %每个候选总簇头至基站距离
    distance_HCH_to_BS = pdist2([S(n+1).xd S(n+1).yd],C.d(index2,:));

    CostofHCH = zeros(1,K);
    for i = 1:K
        CostofHCH(i) = Cost_HCH(Each_cluster(:,1),sum_distance_HCH_to_CH,distance_HCH_to_BS,i);
    end
    [~,index3] = min(CostofHCH);
    S(Each_cluster(index3,2)).type = 'T';%总簇头
    S(Each_cluster(index3,2)).E = S(Each_cluster(index3,2)).E - ERX * ctrPacketLength;%总簇头接收基站发来的分簇信息
%% 4.3成簇，簇内通信
    for i = 1:n
        if ( S(i).type=='N' && S(i).E>0 ) %普通节点
            %加入最近的簇头
            distance_to_cluster = pdist2(C.d(index2,:),[S(i).xd S(i).yd]);
            [min_dis, dis_index] = min(distance_to_cluster);%min_dis返回最短距离，min_dis_cluster返回最短距离对应的簇号
            %接收基站发来的广播的消耗（收到基站发来的分簇信息）
            S(i).E = S(i).E - ERX * ctrPacketLength;
            %向簇头发送数据包
            if (min_dis > do)
                S(i).E = S(i).E - ( ETX*packetLength + Emp*packetLength*min_dis^4); %向簇发送头数据包
            else
                S(i).E = S(i).E - ( ETX*packetLength + Efs*packetLength*min_dis^2); %向簇头发送数据包
            end
            %簇头接收簇成员的数据包
            if(min_dis > 0)
                S(C.id(dis_index)).E = S(C.id(dis_index)).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
            end
        end
    end
%% 4.4簇头和总簇头通信
    TCnumber = Each_cluster(index3,2);%总簇头编号
    for i = 1:K
        j = C.id(index2(i));
        S(j).type = 'C';
        %簇头到总簇头的距离
        distance = sqrt((S(j).xd-S(TCnumber).xd)^2 + (S(j).yd-(S(TCnumber).yd))^2 );
        %簇头向总簇头发送数据包能耗
        if (distance > do)
            S(j).E = S(j).E- ( ETX * (packetLength) + Emp * packetLength*distance^4);
        else
            S(j).E = S(j).E- ( ETX * (packetLength) + Efs * packetLength*distance^2); 
        end
        %总簇头接收簇头的的数据包(不融合数据)
        if(distance > 0)
            S(TCnumber).E = S(TCnumber).E - ERX * packetLength; %接受簇头发来的数据包
        end
    end
%% 4.5总簇头和基站通信
    distance_to_BS = pdist2([S(n+1).xd S(n+1).yd],[S(TCnumber).xd S(TCnumber).yd]);
    if (distance_to_BS > do)
        S(TCnumber).E = S(TCnumber).E- (K * ETX * (packetLength) + Emp * packetLength*distance^4);
    else
        S(TCnumber).E = S(TCnumber).E- (K * ETX * (packetLength) + Efs * packetLength*distance^2); 
    end
    STATISTICS.COUNTCHS(r+1) = K;
end

%% 4、网络运行模块(Leach)
% 死亡节点数指标
first_dead1 = 0;%第一个死亡节点
teenth_dead1 = 0;%10%的死亡节点
all_dead1 = 0;%节点都死亡

%节点死亡数指标对应标记
flag_first_dead1 = 0;
flag_teenth_dead1 = 0;
flag_all_dead1 = 0;

%传输到基站和簇头的比特计数器
packets_TO_BS1 = 0;
packets_TO_CH1 = 0;

%主循环
for r = 0:rmax 
    %每过一个周期，重置G
    if(mod(r, round(1/chp)) == 0)
        for i = 1:n
            N(i).G = 0;
        end
    end
    dead1 = 0;%计算死亡节点数
    energy1 = 0;%每轮节点剩余总能量
    for i = 1:n
        %检查有无死亡节点
        if N(i).E <= 0
            dead1 = dead1+1;
            %第一个节点死亡时间
            if dead1 == 1
                if flag_first_dead1 == 0
                    first_dead1 = r+1;
                    flag_first_dead1 = 1;
                end
            end
            % 10%的节点死亡时间
            if dead1 == 0.1*n
                if flag_teenth_dead1 ==0
                    teenth_dead1 = r+1;
                    flag_teenth_dead1 = 1;
                end
            end
            if dead1 == n
                if flag_all_dead1 == 0
                    all_dead1 = r+1;
                    flag_all_dead1 = 1;
                end
            end
        end
        if N(i).E > 0
            energy1 = energy1 + N(i).E;%统计每轮节点总能量和
            N(i).type = 'N';
        end
    end

    %节点死亡，退出循环，但是一般都是与其他算法比较，由于不同算法最终循环伦次不同
    %所以节点死亡并不退出循环，而是在达到最大循环次数后才结束循环
%     if flag_all_dead == 1
%         break;
%     end
    %r从0开始，但是计算机中数组从1开始，所以采用r+1的下标
    STATISTICS1.DEAD(r+1) = dead1;%每轮死亡节点数
    STATISTICS1.alive(r+1) = n-dead1;%每轮存活节点数
    STATISTICS1.energy(r+1) = energy1;%每轮剩余总能量
    cluster=0;%计数簇头数
    
    %次循环（选簇头）
    if energy1 > 0%网络还剩余能量，这一步在节点都死亡后才有用
        for i=1:n
            if(N(i).E>0)%节点必须有能量
                temp_rand=rand;     
                if ( (N(i).G)<=0) %该节点在候选集合中
                    %选簇头
                    if( temp_rand <= (chp/(1-chp*mod(r,round(1/chp)))))
                        cluster = cluster+1;
                        N(i).type = 'C'; %簇头
                        N(i).G = round(1/chp)-1;%换成"S(i).G = 1"也行，只要不是0
                        C(cluster).xd = N(i).xd;
                        C(cluster).yd = N(i).yd;
                        distance=sqrt( (N(i).xd-(N(n+1).xd))^2 + (N(i).yd-(N(n+1).yd))^2 );%距离基站的距离
                        C(cluster).distance = distance;
                        C(cluster).id = i;
                        distanceBroad = sqrt(xm^2+ym^2);
                        %全网广播自成为簇头,广播TDMA时间表，距离是distanceBroad
                        if (distanceBroad > do)
                            N(i).E = N(i).E- (2* ETX * ctrPacketLength + Emp * ctrPacketLength*distanceBroad^4);
                        else
                            N(i).E = N(i).E- (2* ETX * ctrPacketLength + Efs * ctrPacketLength*distanceBroad^2); 
                        end
                        %簇头向基站发送数据包能耗
                        if (distance > do)
                            N(i).E = N(i).E- ( ETX*(packetLength) + Emp * packetLength*distance^4);
                        else
                            N(i).E = N(i).E- ( ETX*(packetLength) + Efs * packetLength*distance^2); 
                        end
                    end     
                end
            end 
        end
    end
    STATISTICS1.COUNTCHS(r+1) = cluster;

    %次循环(成簇)
    if energy1 > 0%网络还剩余能量，这一步在节点都死亡后才生效
        for i = 1:n
            if ( N(i).type=='N' && N(i).E>0 ) %普通节点
                %如果有簇头存在
                if(cluster>= 1)
                    length = zeros(cluster,1);
                    %加入最近的簇头
                    for c = 1:cluster
                        length(c) = sqrt( (N(i).xd - C(c).xd)^2 + (N(i).yd - C(c).yd)^2 );
                        %%接收簇头发来的广播消耗
                        N(i).E = N(i).E - ERX * ctrPacketLength;
                    end
                    [min_dis, min_dis_cluster] = min(length);%min_dis返回最短距离，min_dis_cluster返回最短距离对应的簇号
                    %向簇头发送数据包
                    if (min_dis > do)
                        N(i).E = N(i).E - ( ETX*packetLength + Emp*packetLength*min_dis^4); %向簇发送头数据包
                    else
                        N(i).E = N(i).E - ( ETX*packetLength + Efs*packetLength*min_dis^2); %向簇头发送数据包
                    end
                    %簇头接收簇成员的数据包
                    if(min_dis > 0)
                        N(C(min_dis_cluster).id).E = N(C(min_dis_cluster).id).E - ( (ERX + EDA)*packetLength ); %接受簇成员发来的数据包
                    end
                %如果本轮没有簇头，则普通节点直接将数据直接发送给基站
                else
                    min_dis = sqrt((N(i).xd-N(n+1).xd)^2 + (N(i).yd-N(n+1).yd)^2);
                end
            end
        end
    end
end

%%   EEUC协议
% eeuc数据变量
ce = 0.5;
T = 0.4;
Rc_max = 90;
TD_MAX = 150;
%计算每个节点的竞争半径
for i = 1:n
    S1(i).Rc = (1-ce*((dmax-S1(i).dtoBS)/(dmax-dmin)))*Rc_max;
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
%% 3、网络运行模块 
%死亡节点数指标
dead_first3 = 0;%第一个死亡节点
dead_ten3 = 0;%10%的死亡节点
dead_half3 = 0;%一半的死亡节点
dead_all3 = 0;%节点都死亡

%节点死亡数指标对应标记
flag_dead_first3 = 0;
flag_dead_ten3 = 0;
flag_dead_half3 = 0;
flag_dead_all3 = 0;

%主循环
for r = 0:rmax 
    dead3 = 0;%计算死亡节点数
    energy3 = 0;%每轮节点剩余总能量
    SNode = [];%存活节点集合
    Cch = [];%候选节点集合
    j = 0;
    for i = 1:n
        %检查有无死亡节点
        if S1(i).E <= 0
            dead3 = dead3+1;
            % 第一个节点死亡时间
            if dead3 == 1
                if flag_dead_first3 == 0
                    dead_first3 = r+1;
                    flag_dead_first3 = 1;
                end
            end
            % 10%的节点死亡时间
            if dead3 == 0.1*n
                if flag_dead_ten3 ==0
                    dead_ten3 = r+1;
                    flag_dead_ten3 = 1;
                end
            end
            % 50%的节点死亡时间
            if dead3 == 0.5*n
                if flag_dead_half3 ==0
                    dead_half3 = r+1;
                    flag_dead_half3 = 1;
                end
            end
            % 全部的节点死亡时间
            if dead3 == n
                if flag_dead_all3 == 0
                    dead_all3 = r+1;
                    flag_dead_all3 = 1;
                end
            end
        elseif S1(i).E > 0
            energy3 = energy3 + S1(i).E;%统计每轮节点总能量和
            S1(i).type = 'N';
            S1(i).pl = packetLength;
            j = j+1;
            SNode.d(j,:) = [S1(i).xd S1(i).yd];%存活节点集合
        end
    end
    
    STATISTICS3.dead(r+1) = dead3;%每轮死亡节点数
    STATISTICS3.alive(r+1) = n-dead3;%每轮存活节点数
    STATISTICS3.energy(r+1) = energy3;%每轮剩余总能量

    %如果只剩下一个节点了，则直接和基站通信
    if dead3 == n-1
    %直接和基站通信
        for i = 1:n
            if S1(i).E > 0
                dtoBS = S1(i).dtoBS;
                if (dtoBS < do)
                    S1(i).E = S1(i).E- (ETX * packetLength + Efs * packetLength * dtoBS^2);
                else
                    S1(i).E = S1(i).E- (ETX * packetLength + Emp * packetLength * dtoBS^4); 
                end
                STATISTICS.COUNTCHS(r+1) = 1;
            end
        end
        continue;
    end

    %如果节点都死亡了，通过continue来跳过下面的操作
    if dead3 == n
        STATISTICS.COUNTCHS(r+1) = 0;
        continue;
    end

    % 广播构建候选簇头
    count = 0;
    for i = 1:n
        if S1(i).E > 0
            miu = rand();
            if  miu < T
                count = count + 1;
                Cch.id(count) = i;%竞选簇头ID
                Cch.E(count) = S1(i).E;%竞选簇头剩余能量
                Cch.d(count,:) = [S1(i).xd S1(i).yd];%竞选簇头坐标
            end
        end
    end

    if isempty(Cch)%如果没有簇头
        %节点直接和基站通信
        for i = 1:n
            if S1(i).E > 0
                dtoBS = S1(i).dtoBS;
                if (dtoBS < do)
                    S1(i).E = S1(i).E- (ETX * packetLength + Efs * packetLength * dtoBS^2);
                else
                    S1(i).E = S1(i).E- (ETX * packetLength + Emp * packetLength * dtoBS^4); 
                end
                STATISTICS.COUNTCHS(r+1) = 1;
            end
        end
        continue;
    end

    %构建候选簇头的邻簇头集合
    %将候选簇头集合按能量从大到小排序
    [E_descend,index1] = sort(Cch.E,'descend');
    %更新候选簇头结构体
    Cch.id = Cch.id(index1);
    Cch.E = E_descend;
    Cch.d = Cch.d(index1,:);
    %构建一个数组，维度为count x 3,第1,2列放坐标3列放参选或退出记号
    SCH = [Cch.d ones(count,1)];%维度count x 3
    distance_SCH = pdist2(Cch.d,Cch.d);%所有候选节点之间的距离，维度count x count
    distance_SCH(logical(eye(size(distance_SCH)))) = inf;
    %竞选簇头
    elected = [];
    for i = 1:count
        if SCH(i,3) == 1%候选簇头未退出竞争
            ID = Cch.id(i);
            id_under_Rc = find(distance_SCH(i,:) <= S1(ID).Rc);
            intersection = intersect(elected,id_under_Rc);%已经当选的簇头和要退出的簇头的交集
            if isempty(intersection)
                SCH(id_under_Rc,3) = 0;
                elected = [elected i];
            else
                SCH(i,3) = 0;
            end
        end
    end
    
    index2 = find(SCH(:,3) == 1);%簇头在SCH数组中对应的编号
    CH = Cch.d(index2,:);%簇头坐标集合
    
    %% 4.2成簇，簇内通信
    %确定簇头
    K = size(index2,1);
    for i =1:K
        CH_id = Cch.id(index2(i));
        S1(CH_id).type = 'C';
    end
    isB = ismember(SNode.d,CH);%簇头节点的位置逻辑值为1，非簇头节点的位置逻辑值为0
    Cnode = reshape(SNode.d(~isB),[],2);%传感器非簇头节点矩阵
    distance_all = pdist2(Cnode,CH);%非簇头和簇头节点的距离,维度MxK
    [dtoCH,index3] = min(distance_all,[],2);
    m = 0;
    %给簇成员标记簇号,记录到簇头的距离以及对应簇头的编号
    for i = 1:n 
        if ( S1(i).type =='N' && S1(i).E>0 )%普通节点
            m = m+1;
            S1(i).of = index3(m);
            S1(i).dtoCH = dtoCH(m);
            S1(i).CHid = Cch.id(index2(S1(i).of));
        end
    end    
    %簇内通信    
    for i = 1:n
        if ( S1(i).type=='N' && S1(i).E>0 )%普通节点
            dtoCH = S1(i).dtoCH;%与簇头的距离
            CH_id = S1(i).CHid;%簇头编号
            if dtoCH < do
                S1(i).E = S1(i).E - (ETX*packetLength + Efs*packetLength*dtoCH^2);%向簇头发送数据包
            else
                S1(i).E = S1(i).E - (ETX*packetLength + Emp*packetLength*dtoCH^4);
            end
            S1(CH_id).E = S1(CH_id).E - (ERX + EDA)*packetLength;%接收并融合簇成员发来的数据包
        end
    end
%% 4.3簇间通信
    C_of_CH = [];%簇头节点结构体
    C_of_CH.d = CH;%簇的坐标集合
    C_of_CH.id = Cch.id(index2);%簇的id集合
    for i = 1:K
        C_of_CH.dtoBS(i) =  S1(C_of_CH.id(i)).dtoBS;%簇头距离基站距离集合
    end
    for i = 1:K
        CH_id = C_of_CH.id(i);
        dtoBS = S1(CH_id).dtoBS;
        if dtoBS < TD_MAX
            if dtoBS < do
                S1(CH_id).E = S1(CH_id).E - ( ETX*S1(CH_id).pl + Efs*S1(CH_id).pl*dtoBS^2);
            else
                S1(CH_id).E = S1(CH_id).E - ( ETX*S1(CH_id).pl + Emp*S1(CH_id).pl*dtoBS^4);
            end
            S1(CH_id).pl = 0;
        else
            dt = CH_id;
            while dtoBS >= TD_MAX
                A = [S1(dt).xd S1(dt).yd];
                Ere = [S1(C_of_CH.id).E];%每个簇头的剩余能量
                [index4,sign] = CostEEUC(dtoBS,A,C_of_CH.d,C_of_CH.dtoBS,Ere);
                if sign == 0%没有节能的中继节点，则直接和基站通信
                    S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Emp*S1(dt).pl*dtoBS^4);%向基站发送数据包
                    S1(dt).pl = 0;
                    dtoBS = 0;
                else %即有节能的中继节点，则与中继节点通信
                    CN_id = C_of_CH.id(index4);%中继节点id
                    dtoCN = pdist2(A,C_of_CH.d(index4,:));%与中继节点的距离
                    if (dtoCN < do)
                        S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Efs*S1(dt).pl*dtoCN^2);%向中继节点发送数据包
                    else
                        S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Emp*S1(dt).pl*dtoCN^4);
                    end
                    %中继节点接收传输节点的数据包
                    if(dtoCN > 0)
                        S1(CN_id).E = S1(CN_id).E - ERX*S1(dt).pl;%接受传输节点发来的数据包,不融合数据
                        S1(CN_id).pl = S1(CN_id).pl + S1(dt).pl;
                    end
                    S1(dt).pl = 0;
                    dtoBS = S1(CN_id).dtoBS;
                    dt = CN_id;
                end
            end
            if dtoBS>0 && dtoBS<TD_MAX%最后的中继节点将数据传输给基站
                %向基站发送数据包
                if (dtoBS < do)
                    S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Efs*S1(dt).pl*dtoBS^2);
                else
                    S1(dt).E = S1(dt).E - ( ETX*S1(dt).pl + Emp*S1(dt).pl*dtoBS^4);
                end
                S1(dt).pl = 0;
            end
        end
    end
end


%% 绘图显示
figure;
plot(0:rmax, STATISTICS.DEAD, 'r',0:rmax, STATISTICS1.DEAD, 'g',0:rmax, STATISTICS2.DEAD, 'm',  0:rmax, STATISTICS3.dead, 'b','LineWidth', 2);
xlabel('Number of rounds'); ylabel('Number of dead nodes');
legend('PL-EBC','Leach','GADM-A*','EEUC')
figure;
plot(0:rmax, STATISTICS.alive, 'r',0:rmax, STATISTICS1.alive, 'g',0:rmax, STATISTICS2.alive, 'm', 0:rmax, STATISTICS3.alive,'b','LineWidth', 2);
xlabel('Number of rounds'); ylabel('Number of active nodes');
legend('PL-EBC','Leach','GADM-A*','EEUC')
figure;
plot(0:rmax, STATISTICS.energy, 'r',0:rmax, STATISTICS1.energy, 'g',0:rmax, STATISTICS2.energy, 'm', 0:rmax, STATISTICS3.energy, 'b','LineWidth', 2);
xlabel('Number of rounds'); ylabel('Dump energy');
legend('PL-EBC','Leach','GADM-A*','EEUC')  
figure;
plot(0:rmax, STATISTICS.COUNTCHS, 'r',0:rmax, STATISTICS1.COUNTCHS, 'g', 'LineWidth', 2);
xlabel('轮数'); ylabel('簇头数');
legend('mypso','Leach')
%% 适应值函数
% PopPos 是一个矩阵，其中每一行代表一个个体的位置。
% Dim 是最优簇头的数量，也是适应度函数的维度。PopFit 是一个向量，用于存储每个个体的适应度值。
function Fit = fit(swq,d,num_zhongqun,k,n,cunhuo) 
nPop = num_zhongqun;   % 种群数量
Dim = k;  % 适应值函数的维度即最优簇头数
    Fit=zeros(1,nPop);   % 创建一个 1 行 nPop 列的列向量，所有元素都是 0。这个向量用于存储种群中每个个体的适应度值。
    for w = 1:nPop     % 循环提取种群PopPos矩阵中个体
        geti = swq(w, :);   % 从 PopPos 矩阵中提取第w行个体的所有数据。                                             
        for h = 1:Dim
            q1 = 0.29; % 权重
            q2 = 0.08; % 权重
            q3 = 0.19; % 权重
            q4 = 0.23; % 权重
            q5 = 0.21; % 权重
            for o = 1:Dim  % Dim为最优簇头数目
                for l = o+1:Dim
                    disNN = 0;  % 初始化距离和
                    disNNone = sqrt((d(geti(o)).xd - d(geti(l)).xd)^2 + (d(geti(o)).yd - d(geti(l)).yd)^2);  % 簇首h之间的距离
                    disNN = disNN + disNNone;  % 各个簇首之间的距离的累加和
                end
            end
            for e = 1:Dim  % Dim为最优簇头数目
                for v = 1:n  % n为场地中节点数目
                    disNC = 0;  % 初始化距离和
                    disNCone = sqrt((d(geti(e)).xd - d(cunhuo(v)).xd)^2 + (d(geti(e)).yd - d(cunhuo(v)).yd)^2);  % 簇首h与每个节点之间的距离
                    disNC = disNC + disNCone;  % 各个簇首与每个节点之间的距离的累加和
                end
            end
            onePopFit = q1*(1/(d(geti(h)).E))+q2*(d(geti(h)).G)+q3*(1/disNN)+q4*(sqrt((d(geti(h)).xd - d(n+1).xd)^2+ (d(geti(h)).yd - d(n+1).yd)^2))+q5*disNC;
            Fit(w) = Fit(w) + onePopFit;  % 适应值函数设计
        end
    end
end