import os
import numpy as np
import pydicom  # 用于读取 DICOM 图像
from tqdm import tqdm  # 显示进度条
import cv2

# 数据集路径
data_dir = '/home/chy/Project/RDA-Net/10AAPM-Mayo-CT-Challenge10/'

# 初始化统计变量
pixel_values = []

# 遍历所有图像文件
for root, _, files in os.walk(data_dir):
    for file in tqdm(files, desc=f'Processing files in {root}'):
        file_path = os.path.join(root, file)

        try:
            if file.lower().endswith(('.ima', '.dcm')):  # 支持 .IMA 和 .dcm 格式
                ds = pydicom.dcmread(file_path)
                img = ds.pixel_array.astype(np.float32)
                # 裁剪CT值范围（通常为-1024到3071）
                img = np.clip(img, -1024, 3071)
                pixel_values.extend(img.flatten())
            elif file.lower().endswith(('.png', '.jpg', '.jpeg')):  # 支持常见图像格式
                img = cv2.imread(file_path, cv2.IMREAD_GRAYSCALE).astype(np.float32)
                pixel_values.extend(img.flatten())
        except Exception as e:
            print(f"Error reading {file_path}: {e}")

# 计算均值和标准差
ct_mean = np.mean(pixel_values)
ct_std = np.std(pixel_values)

print(f"CT Mean: {ct_mean:.4f}")
print(f"CT Std: {ct_std:.4f}")
